/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search;

import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.configuration.SystemSettings;
import com.ibm.es.nuvo.search.NameValuePairImpl;
import com.ibm.es.nuvo.search.common.FileFetcherURI;
import com.ibm.es.nuvo.util.stream.DocumentFieldInputStream;
import com.ibm.siapi.common.NameValuePair;
import com.ibm.siapi.search.Query;
import com.ibm.siapi.search.Result;
import com.ibm.siapi.search.ResultCategory;
import com.ibm.supa.search.SearchUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class ResultImpl
implements Result {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private boolean supaWebContext = false;
    private String collectionId = null;
    private String queryIndex = null;
    private String title = null;
    private String highlightedDocumentURI = null;
    private Query query = null;
    private double score = 0.0;
    private int docId;
    private Document doc = null;
    private String description = null;
    private Properties properties = null;
    private Properties metadata = null;
    private Properties metadataShort = null;
    private boolean ClickThroughTracking = false;
    private static final long serialVersionUID = -8266603818552046204L;

    public ResultImpl(Document doc, int docId, double score, Query query, String collectionId) {
        this.score = score;
        this.docId = docId;
        this.doc = doc;
        this.query = query;
        this.collectionId = collectionId;
        this.setClickThroughTracking();
    }

    public String getAuthor() {
        String author = null;
        if (this.query.isAttributeReturned(-19)) {
            author = this.doc.get("author");
        }
        return author;
    }

    public String getDocumentID() {
        return this.doc.get("uri");
    }

    public ResultCategory[] getCategories() {
        return null;
    }

    public String getCollectionID() {
        return this.collectionId;
    }

    public String getDocumentType() {
        String docType = null;
        if (this.query.isAttributeReturned(-6)) {
            docType = this.doc.get("doctype");
        }
        return docType;
    }

    public String getDocumentSource() {
        String source = null;
        if (this.query.isAttributeReturned(-7)) {
            source = this.doc.get("source");
        }
        return source;
    }

    public String getLanguage() {
        String language = null;
        if (this.query.isAttributeReturned(-8)) {
            language = this.doc.get("language");
        }
        return language;
    }

    public Date getDate() {
        Date date = null;
        if (this.query.isAttributeReturned(-9)) {
            Calendar cal = Calendar.getInstance();
            try {
                long timeInMillis = Long.parseLong(this.doc.get("docdate"));
                cal.setTimeInMillis(timeInMillis);
                date = cal.getTime();
            }
            catch (NumberFormatException e) {
                date = new Date();
            }
        }
        return date;
    }

    public String getDescription() {
        String retDesc = null;
        if (this.query.isAttributeReturned(-1)) {
            retDesc = this.description;
        }
        return retDesc;
    }

    public String getDocumentURI() {
        String uri = this.getNonClickThroughDocumentURI();
        if (this.ClickThroughTracking) {
            uri = this.getClickThroughTrackingURL(uri);
        }
        return uri;
    }

    public String getNonClickThroughDocumentURI() {
        String uri = null;
        if (this.query.isAttributeReturned(-11)) {
            uri = this.doc.get("uri");
            if (this.isCrawled() && !uri.startsWith("http://") && !uri.startsWith("https://")) {
                uri = FileFetcherURI.constructFetchableURI(this);
            }
        }
        if (this.supaWebContext) {
            return SearchUtils.replaceSearchContextPath(uri);
        }
        return uri;
    }

    public boolean isCrawled() {
        boolean crawled = false;
        byte[] sourceType = this.getBinaryFieldValue("_documentSource");
        if (sourceType != null && sourceType.length > 0) {
            crawled = sourceType[0] == 0;
        }
        return crawled;
    }

    private boolean isFetchable(String uri) {
        boolean fetchable = false;
        if (uri != null && this.isCrawled()) {
            fetchable = true;
        }
        return fetchable;
    }

    public boolean isURIClickable() {
        if (this.isCrawled()) {
            return true;
        }
        String uri = this.doc.get("uri");
        if (null == uri) {
            return false;
        }
        boolean isClickable = true;
        try {
            uri = URLEncoder.encode(uri, "UTF-8");
            new URI(uri);
        }
        catch (URISyntaxException e) {
            isClickable = false;
        }
        catch (UnsupportedEncodingException uee) {
            isClickable = false;
        }
        return isClickable;
    }

    public String getHighlightedDocumentURI() {
        String uri = null;
        if (this.query.isAttributeReturned(-11)) {
            uri = this.highlightedDocumentURI;
        }
        return uri;
    }

    public String getTitle() {
        String trimmedTitle;
        String docTitle = null;
        if (this.title != null && this.query.isAttributeReturned(-2) && (trimmedTitle = this.title.trim()).length() > 0) {
            docTitle = trimmedTitle;
        }
        return docTitle;
    }

    public NameValuePair[] getFields() {
        if (!this.query.isAttributeReturned(-3)) {
            return null;
        }
        NameValuePair[] fieldArray = null;
        ArrayList<NameValuePairImpl> nameValuePairs = null;
        Enumeration fieldEnumeration = this.doc.fields();
        while (fieldEnumeration.hasMoreElements()) {
            if (nameValuePairs == null) {
                nameValuePairs = new ArrayList<NameValuePairImpl>();
            }
            Field field = (Field)fieldEnumeration.nextElement();
            nameValuePairs.add(new NameValuePairImpl(field.name(), field.stringValue()));
        }
        if (nameValuePairs != null) {
            fieldArray = nameValuePairs.toArray(new NameValuePairImpl[nameValuePairs.size()]);
        }
        return fieldArray;
    }

    public String[] getFields(String name) {
        String[] fields = null;
        if (this.query.isAttributeReturned(-3)) {
            fields = this.doc.getValues(name);
        }
        return fields;
    }

    public InputStream getBinaryField(String name) {
        if (!this.query.isAttributeReturned(-3)) {
            return null;
        }
        Field field = this.doc.getField(name);
        if (field == null) {
            return null;
        }
        return new DocumentFieldInputStream(this.doc, name);
    }

    public byte[] getBinaryFieldValue(String name) {
        Field field = this.doc.getField(name);
        if (field == null) {
            return null;
        }
        return field.binaryValue();
    }

    public double getScore() {
        double retScore = 0.0;
        if (this.query.isAttributeReturned(-10)) {
            retScore = this.score;
        }
        return retScore;
    }

    public int getDocId() {
        return this.docId;
    }

    public boolean isFirstOfASite() {
        return false;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(name);
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(name, value);
    }

    public Properties getMetadata() {
        return this.metadata;
    }

    public String getMetadataValue(String name) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.getProperty(name);
    }

    public void setMetadataValue(String name, String value) {
        if (this.metadata == null) {
            this.metadata = new Properties();
        }
        this.metadata.setProperty(name, value);
    }

    public String getMetadataValueShort(String name) {
        if (this.metadataShort == null) {
            return null;
        }
        return this.metadataShort.getProperty(name);
    }

    public void setMetadataValueShort(String name, String value) {
        if (this.metadataShort == null) {
            this.metadataShort = new Properties();
        }
        this.metadataShort.setProperty(name, value);
    }

    public String[] getMetadataKeys() {
        Enumeration<?> e;
        String[] keys = null;
        if (this.metadata != null && (e = this.metadata.propertyNames()) != null) {
            Vector<String> v = new Vector<String>();
            while (e.hasMoreElements()) {
                v.add((String)e.nextElement());
            }
            keys = v.toArray(new String[0]);
        }
        return keys;
    }

    private String getHtmlCacheBaseURI(String requestPath) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(requestPath);
        buffer.append("?query=cache::");
        String encodedUrl = "";
        try {
            encodedUrl = URLEncoder.encode(this.getDocumentID(), "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        buffer.append(encodedUrl);
        buffer.append("&index=");
        String encodedCollectionId = "";
        try {
            encodedCollectionId = URLEncoder.encode(this.getCollectionID(), "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        buffer.append(encodedCollectionId);
        return buffer.toString();
    }

    public String getHtmlCacheURI(String requestPath) {
        String returnUrl = this.getHtmlCacheBaseURI(requestPath);
        if (this.ClickThroughTracking) {
            returnUrl = this.getClickThroughTrackingURL(returnUrl);
        }
        return returnUrl;
    }

    public String getBinaryCacheURI(String requestPath) {
        StringBuffer buffer = new StringBuffer();
        String binaryCacheURI = this.getHtmlCacheBaseURI(requestPath);
        buffer.append(binaryCacheURI);
        buffer.append("&output=binary");
        String returnUrl = buffer.toString();
        if (this.ClickThroughTracking) {
            returnUrl = this.getClickThroughTrackingURL(returnUrl);
        }
        return returnUrl;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void setTitle(String title) {
        this.title = title;
    }

    void setHighlightedDocumentURI(String uri) {
        this.highlightedDocumentURI = uri;
    }

    void setClickThroughTracking() {
        SettingsConfigurationManager settingsConfigMgr = SettingsConfigurationManager.getConfigurationManager();
        SystemSettings systemSettings = (SystemSettings)settingsConfigMgr.getSettings(SettingsConfigurationManager.SettingsType.SystemSettings);
        this.ClickThroughTracking = systemSettings.getClickThroughTracking();
    }

    public boolean isClickThroughTrackingEnabled() {
        return this.ClickThroughTracking;
    }

    public String getClickThroughTrackingURL(String resultURL) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("/search/click");
        buffer.append("?query=");
        try {
            buffer.append(URLEncoder.encode(this.query.getText(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        String resultTitle = this.doc.get("title");
        if (null == resultTitle) {
            resultTitle = this.getDocumentID();
        }
        resultTitle = resultTitle.trim();
        buffer.append("&title=");
        try {
            buffer.append(URLEncoder.encode(resultTitle, "UTF-8"));
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        buffer.append("&url=");
        try {
            buffer.append(URLEncoder.encode(resultURL, "UTF-8"));
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        buffer.append("&spaceId=");
        try {
            buffer.append(URLEncoder.encode(this.getSpaceId(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        buffer.append("&index=");
        try {
            buffer.append(URLEncoder.encode(this.getCollectionID(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        buffer.append("&charset=");
        try {
            String charset = this.getCharset();
            if (charset == null) {
                charset = "";
            }
            buffer.append(URLEncoder.encode(charset, "UTF-8"));
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        buffer.append("&mimeType=");
        try {
            String mimeType = this.getDocumentType();
            if (mimeType == null) {
                mimeType = "";
            }
            buffer.append(URLEncoder.encode(mimeType, "UTF-8"));
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        if (this.supaWebContext) {
            return SearchUtils.replaceSearchContextPath(buffer.toString());
        }
        return buffer.toString();
    }

    public String getCharset() {
        String[] charsetValues = this.getFields("charset");
        String charset = null;
        if (charsetValues != null) {
            charset = charsetValues[0];
        }
        return charset;
    }

    public String getSpaceId() {
        String[] spaceValues = this.getFields("_crwsp");
        String spaceValue = "";
        if (spaceValues != null) {
            spaceValue = spaceValues[0];
        }
        return spaceValue;
    }

    public void setSupaWebContext(boolean supaWebContext) {
        this.supaWebContext = supaWebContext;
    }

    public String getQueryIndex() {
        return this.queryIndex;
    }

    public void setQueryIndex(String queryIndex) {
        this.queryIndex = queryIndex;
    }

    public void setScore(double score) {
        this.score = score;
    }
}

