/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.search.ResultFetcher;
import com.ibm.es.nuvo.search.ResultFilter;
import com.ibm.es.nuvo.search.ResultImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FilteringAndBatchingResultFetcher
implements ResultFetcher {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private ResultFetcher resultFetcher;
    private List<ResultFilter> filters = new LinkedList<ResultFilter>();
    private float loadFactor;
    private int maxBatchSize;
    private int numExecutions;

    public FilteringAndBatchingResultFetcher(ResultFetcher resultFetcher) {
        this.resultFetcher = resultFetcher;
        this.maxBatchSize = 50;
        this.loadFactor = 1.5f;
    }

    public void addFilter(ResultFilter filter) {
        this.filters.add(filter);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ResultImpl[] fetch(int firstResult, int numResultsRequested) throws ExtendedException {
        ArrayList<ResultImpl> results = new ArrayList<ResultImpl>();
        int numResultsFilterAccepted = 0;
        int numResultsDiscarded = 0;
        int curFirstResult = 0;
        boolean doFilter = true;
        if (this.filters.isEmpty()) {
            this.loadFactor = 1.0f;
            curFirstResult = firstResult;
            doFilter = false;
        }
        boolean more = true;
        block0: while (more) {
            ResultImpl[] resultCandidates;
            int batchSize = Math.min(this.maxBatchSize, (int)((float)(numResultsRequested - results.size()) * this.loadFactor));
            if (batchSize < 2) {
                batchSize = 2;
            }
            if ((resultCandidates = this.resultFetcher.fetch(curFirstResult, batchSize)) == null) {
                return results.toArray(new ResultImpl[results.size()]);
            }
            if (resultCandidates.length < batchSize) {
                more = false;
            }
            int i = 0;
            while (true) {
                block16: {
                    if (i >= resultCandidates.length) continue block0;
                    boolean accept = true;
                    if (doFilter) {
                        Iterator<ResultFilter> it = this.filters.iterator();
                        while (it.hasNext()) {
                            ResultFilter filter = it.next();
                            if (filter.disableFilter(numResultsFilterAccepted)) {
                                it.remove();
                                continue;
                            }
                            if (filter.accept(resultCandidates[i])) continue;
                            accept = false;
                            ++numResultsDiscarded;
                            break;
                        }
                    }
                    if (accept) {
                        ++numResultsFilterAccepted;
                        if (doFilter && this.filters.isEmpty()) {
                            doFilter = false;
                            if (firstResult + numResultsDiscarded > curFirstResult) {
                                int newCurFirstResult = firstResult + numResultsDiscarded;
                                if (newCurFirstResult < curFirstResult + resultCandidates.length - i) {
                                    int skip = newCurFirstResult - curFirstResult - 1;
                                    i += skip;
                                    curFirstResult += skip;
                                    break block16;
                                } else {
                                    curFirstResult = newCurFirstResult;
                                    continue block0;
                                }
                            }
                        }
                        if (curFirstResult >= firstResult + numResultsDiscarded) {
                            results.add(resultCandidates[i]);
                            if (results.size() == numResultsRequested) {
                                more = false;
                                continue block0;
                            }
                        }
                    }
                }
                ++i;
                ++curFirstResult;
            }
            break;
        }
        return results.toArray(new ResultImpl[results.size()]);
    }

    private void adjustLoadFactor(float adjustedLoadFactor) {
        this.loadFactor = (this.loadFactor * (float)(this.numExecutions - 1) + adjustedLoadFactor) / (float)this.numExecutions;
        if (this.loadFactor < 1.0f) {
            this.loadFactor = 1.0f;
        }
    }
}

