/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;

public class FieldCache {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static long[] getLongs(IndexReader indexReader, String fieldName) throws IOException {
        final String targetFieldName = fieldName;
        FieldSelector fieldSelector = new FieldSelector(){

            public FieldSelectorResult accept(String name) {
                FieldSelectorResult result = FieldSelectorResult.NO_LOAD;
                if (name.equals(targetFieldName)) {
                    result = FieldSelectorResult.LOAD_AND_BREAK;
                }
                return result;
            }
        };
        long[] fieldValues = new long[indexReader.maxDoc()];
        for (int i = 0; i < fieldValues.length; ++i) {
            if (indexReader.isDeleted(i)) continue;
            Document doc = indexReader.document(i, fieldSelector);
            try {
                fieldValues[i] = Long.parseLong(doc.get(fieldName));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return fieldValues;
    }
}

