/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search;

import com.ibm.es.nuvo.crawler.web.util.BloomFilter;
import com.ibm.es.nuvo.search.HashedScoreDoc;
import com.ibm.es.nuvo.search.HitQueue;
import com.ibm.es.nuvo.util.NumericUtils;
import com.ibm.es.nuvo.util.PriorityQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.search.TopDocs;

public class ExactDupEliminatingHitCollector
extends TopDocCollector {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private HitQueue hq = new HitQueue(1000);
    private float minScore = 0.0f;
    private int totalHits;
    private BloomFilter bloomFilter;
    private long[] docHashCodes;
    private static final int maxHits = 1000;
    private static final int num32BitWordsInMillionBits = 156250;
    private static final int numHashFunctions = 8;
    private boolean removedDups;

    public ExactDupEliminatingHitCollector(long[] docHashCodes) {
        super(0);
        this.docHashCodes = docHashCodes;
        this.bloomFilter = new BloomFilter(156250, 8);
        this.removedDups = false;
    }

    public void collect(int doc, float score) {
        if (score > 0.0f) {
            ++this.totalHits;
            if (this.hq.size() < 1000 || score >= this.minScore) {
                long hash = this.docHashCodes[doc];
                byte[] docHash = NumericUtils.convertLongToByteArray(hash);
                if (hash == 0L || !this.bloomFilter.contains(docHash)) {
                    if (hash != 0L) {
                        this.bloomFilter.add(docHash);
                    }
                    this.hq.insert((Object)new HashedScoreDoc(doc, score, hash));
                } else {
                    PriorityQueue.QueueHandle qh = this.hq.find((Object)new HashedScoreDoc(0, 0.0f, hash));
                    if (qh != null) {
                        HashedScoreDoc hashDoc = (HashedScoreDoc)((Object)qh.getObject());
                        if (hashDoc.score < score) {
                            this.hq.remove(qh);
                            this.hq.insert((Object)new HashedScoreDoc(doc, score, hash));
                        }
                        this.removedDups = true;
                    } else {
                        this.hq.insert((Object)new HashedScoreDoc(doc, score, hash));
                    }
                }
                this.minScore = ((HashedScoreDoc)((Object)this.hq.top())).score;
            }
        }
    }

    public TopDocs topDocs() {
        ScoreDoc[] sd = new ScoreDoc[this.hq.size()];
        float maxScore = 0.0f;
        for (int i = this.hq.size() - 1; i >= 0; --i) {
            HashedScoreDoc doc = (HashedScoreDoc)((Object)this.hq.pop());
            sd[i] = doc;
            if (!(doc.score > maxScore)) continue;
            maxScore = doc.score;
        }
        TopDocs docs = super.topDocs();
        docs.setMaxScore(maxScore);
        docs.scoreDocs = sd;
        docs.totalHits = this.totalHits;
        return docs;
    }

    public boolean removedDups() {
        return this.removedDups;
    }
}

