/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search;

import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.BaseQuery;
import com.ibm.siapi.search.SearchState;
import java.util.Hashtable;
import java.util.Properties;

public class BaseQueryImpl
implements BaseQuery {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 3740745196431590132L;
    private String[] returnedFields;
    private String queryLanguage;
    private String queryText;
    private int startResultRank;
    private int numberOfRequestedResults;
    private Properties queryProperties = new Properties();
    private String sortKey;
    private int sortOrder;
    private boolean siteCollapsingEnabled;
    private boolean predefinedResultsEnabled;
    private boolean spellCorrectionEnabled;
    private int synonymExpansionMode;
    private int categoriesDetailLevel;
    private String id;
    private String aclConstraints;
    private SearchState searchState;
    private int linguisticMode;
    private Hashtable<Integer, Boolean> returnedAttributesTable;

    public BaseQueryImpl() throws SiapiException {
        this.setSortKey("relevance");
        this.setSortOrder(-1);
        this.setSiteCollapsingEnabled(false);
        this.setPredefinedResultsEnabled(true);
        this.setSpellCorrectionEnabled(false);
        this.setLinguisticMode(-15);
        this.returnedAttributesTable = new Hashtable();
    }

    public String getText() {
        return this.queryText;
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public String[] getReturnedFields() {
        return this.returnedFields;
    }

    public void setReturnedFields(String[] fields) throws SiapiException {
        this.returnedFields = fields;
    }

    public void resetReturnedFields() {
        this.returnedFields = null;
    }

    public int getNumRequestedResults() {
        return this.numberOfRequestedResults;
    }

    public int getFirstRequestedResult() {
        return this.startResultRank;
    }

    public void setRequestedResultRange(int fromResult, int numberOfResults) {
        this.startResultRank = fromResult;
        this.numberOfRequestedResults = numberOfResults;
    }

    public String getProperty(String name) {
        return this.queryProperties.getProperty(name);
    }

    public void setProperty(String name, String value) throws SiapiException {
        this.queryProperties.setProperty(name, value);
    }

    public Properties getProperties() {
        return this.queryProperties;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String key) throws SiapiException {
        if (!key.equals("relevance")) {
            throw new SiapiException(1, 23, "Unsupported sort key: " + key);
        }
        this.sortKey = key;
    }

    public int getSortPoolSize() {
        return -1;
    }

    public void setSortPoolSize(int poolSize) throws SiapiException {
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int order) throws SiapiException {
        if (order != -1) {
            throw new SiapiException(1, 23, "Sort order must be DESCENDING");
        }
        this.sortOrder = order;
    }

    public boolean isSiteCollapsingEnabled() {
        return this.siteCollapsingEnabled;
    }

    public void setSiteCollapsingEnabled(boolean value) throws SiapiException {
        this.siteCollapsingEnabled = value;
    }

    public boolean isPredefinedResultsEnabled() {
        return this.predefinedResultsEnabled;
    }

    public void setPredefinedResultsEnabled(boolean value) throws SiapiException {
        this.predefinedResultsEnabled = value;
    }

    public void setSpellCorrectionEnabled(boolean value) throws SiapiException {
        this.spellCorrectionEnabled = value;
    }

    public boolean isSpellCorrectionEnabled() {
        return this.spellCorrectionEnabled;
    }

    public void setSynonymExpansionMode(int mode) throws SiapiException {
        switch (mode) {
            case -14: 
            case -13: 
            case -12: {
                this.synonymExpansionMode = mode;
                break;
            }
            default: {
                throw new SiapiException(1, 23, "Invalid synonym expansion mode:" + mode);
            }
        }
    }

    public int getSynonymExpansionMode() {
        return this.synonymExpansionMode;
    }

    public void setResultCategoriesDetailLevel(int detailLevel) {
        this.categoriesDetailLevel = detailLevel;
    }

    public int getResultCategoriesDetailLevel() {
        return this.categoriesDetailLevel;
    }

    public void setReturnedAttribute(int attributeType, boolean isReturned) throws SiapiException {
        switch (attributeType) {
            case -19: 
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                this.returnedAttributesTable.put(new Integer(attributeType), new Boolean(isReturned));
                break;
            }
            default: {
                throw new SiapiException(1, 23, "Invalid attributeType provided:" + attributeType);
            }
        }
    }

    public boolean isAttributeReturned(int attributeType) {
        Boolean isReturned = this.returnedAttributesTable.get(new Integer(attributeType));
        if (isReturned == null) {
            return false;
        }
        return isReturned;
    }

    public void setQueryID(String id) {
        this.id = id;
    }

    public String getQueryID() {
        return this.id;
    }

    public void setACLConstraints(String aclConstraints) {
        this.aclConstraints = aclConstraints;
    }

    public String getACLConstraints() {
        return this.aclConstraints;
    }

    public void setSearchState(SearchState searchState) {
        this.searchState = searchState;
    }

    public SearchState getSearchState() {
        return this.searchState;
    }

    public void setLinguisticMode(int mode) throws SiapiException {
        switch (mode) {
            case -18: 
            case -17: 
            case -16: 
            case -15: {
                this.linguisticMode = mode;
                break;
            }
            default: {
                throw new SiapiException(1, 23, "Illegal linguistic mode provided:" + mode);
            }
        }
    }

    public int getLinguisticMode() {
        return this.linguisticMode;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setText(String queryText) {
        this.queryText = queryText;
    }

    protected void setQueryLanguage(String queryLanguage) {
        this.queryLanguage = queryLanguage;
    }
}

