/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.quicklinks.index;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.quicklinks.factory.IKeyword;
import com.ibm.es.nuvo.quicklinks.factory.IQuickLink;
import com.ibm.es.nuvo.quicklinks.factory.IQuickLinks;
import com.ibm.es.nuvo.quicklinks.factory.SAXQuickLinksFactory;
import com.ibm.es.nuvo.quicklinks.index.QuicklinksWriterInstantiationException;
import com.ibm.es.nuvo.tokenizer.TokenizerUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.server.UID;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

public class QuicklinksWriter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private IndexWriter indexWriter;
    private String collectionId;

    public static QuicklinksWriter open(String collectionId, boolean create) throws QuicklinksWriterInstantiationException {
        return new QuicklinksWriter(collectionId, create);
    }

    public static QuicklinksWriter open(String collectionId) throws QuicklinksWriterInstantiationException {
        return new QuicklinksWriter(collectionId);
    }

    public void addQuicklink(IQuickLink ql) throws IOException {
        try {
            Document d = new Document();
            d.add((Fieldable)new Field("uri", ql.getURL(), Field.Store.YES, Field.Index.NO));
            d.add((Fieldable)new Field("_static_summary", ql.getSummary(), Field.Store.YES, Field.Index.NO));
            d.add((Fieldable)new Field("title", ql.getTitle(), Field.Store.YES, Field.Index.NO));
            String key = ql.getID();
            if (key == null || key.length() == 0) {
                key = this.generateKey();
            }
            d.add((Fieldable)new Field("_qlkey", key, Field.Store.YES, Field.Index.UN_TOKENIZED));
            IKeyword[] keywords = ql.getKeywords().getKeywords();
            StandardAnalyzer sa = new StandardAnalyzer();
            for (int i = 0; i < keywords.length; ++i) {
                d.add((Fieldable)new Field("_orig_keywords", keywords[i].getValue(), Field.Store.YES, Field.Index.NO));
                String[] quicklinksTerms = TokenizerUtilities.whiteSpaceTokenize(keywords[i].getValue());
                String keywordTerm = QuicklinksWriter.createKeywordTerm(quicklinksTerms);
                d.add((Fieldable)new Field("_keywords", keywordTerm, Field.Store.NO, Field.Index.UN_TOKENIZED));
            }
            this.indexWriter.updateDocument(new Term("_qlkey", key), d, (Analyzer)sa);
        }
        catch (Exception e) {
            IOException exc = new IOException();
            exc.initCause(e);
            throw exc;
        }
    }

    public void removeQuicklink(String id) throws IOException {
        this.indexWriter.deleteDocuments(new Term("_qlkey", id));
    }

    public void close() throws IOException {
        this.indexWriter.close();
    }

    public void addQuicklinks(IQuickLinks qls) throws IOException {
        IQuickLink[] quicklinks = qls.getQuicklinks();
        for (int i = 0; i < quicklinks.length; ++i) {
            this.addQuicklink(quicklinks[i]);
        }
    }

    public void addQuicklinks(InputStream is) throws IOException {
        SAXQuickLinksFactory qlFactory = new SAXQuickLinksFactory();
        IQuickLinks qls = (IQuickLinks)qlFactory.mapXMLFrom(is);
        if (qls == null) {
            Message msg = new Message("S0081E.QUICKLINK_XML_STREAM_PARSE_ERROR");
            msg.addArgument(this.collectionId);
            ExtendedException ee = new ExtendedException(msg);
            IOException ioe = new IOException();
            ioe.initCause(ee);
            throw ioe;
        }
        this.addQuicklinks(qls);
    }

    private QuicklinksWriter(String collectionId, boolean create) throws QuicklinksWriterInstantiationException {
        try {
            String quicklinksDirectory = QuicklinksWriter.getQuicklinksDirectory(collectionId);
            this.init(collectionId, quicklinksDirectory, create);
        }
        catch (Exception e) {
            throw new QuicklinksWriterInstantiationException(e);
        }
    }

    private QuicklinksWriter(String collectionId) throws QuicklinksWriterInstantiationException {
        try {
            boolean create = true;
            String quicklinksDirectory = QuicklinksWriter.getQuicklinksDirectory(collectionId);
            if (IndexReader.indexExists((String)quicklinksDirectory)) {
                create = false;
            }
            this.init(collectionId, quicklinksDirectory, create);
        }
        catch (Exception e) {
            throw new QuicklinksWriterInstantiationException(e);
        }
    }

    private void init(String cid, String directory, boolean create) throws IOException {
        this.indexWriter = new IndexWriter(directory, (Analyzer)new StandardAnalyzer(), create);
        this.collectionId = cid;
    }

    public static synchronized String createKeywordTerm(String[] terms) {
        Arrays.sort(terms);
        StringBuilder kwTerm = new StringBuilder();
        for (int i = 0; i < terms.length; ++i) {
            kwTerm.append(terms[i] + " ");
        }
        return kwTerm.toString().trim();
    }

    private static String getQuicklinksDirectory(String collectionId) throws ExtendedException {
        ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfig = configManager.getCollection(collectionId);
        return collectionConfig.getIndexPath(IndexDescriptor.IndexType.QuickLink);
    }

    private String generateKey() {
        String key = new UID().toString().replaceAll(":", "0");
        return key;
    }
}

