/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.quicklinks.index;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.quicklinks.factory.IQuickLinks;
import com.ibm.es.nuvo.quicklinks.factory.Keyword;
import com.ibm.es.nuvo.quicklinks.factory.Keywords;
import com.ibm.es.nuvo.quicklinks.factory.QuickLink;
import com.ibm.es.nuvo.quicklinks.factory.QuickLinks;
import com.ibm.es.nuvo.quicklinks.index.QuicklinksReaderInstantiationException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;

public class QuicklinksReader {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private IndexReader indexReader;

    public static QuicklinksReader open(String collectionId) throws QuicklinksReaderInstantiationException {
        return new QuicklinksReader(collectionId);
    }

    public void close() throws IOException {
        this.indexReader.close();
    }

    public IQuickLinks getQuicklinks() throws IOException {
        QuickLinks qls = new QuickLinks();
        for (int i = 0; i < this.indexReader.maxDoc(); ++i) {
            if (this.indexReader.isDeleted(i)) continue;
            Document doc = this.indexReader.document(i);
            QuickLink ql = new QuickLink();
            ql.setURL(doc.get("uri"));
            ql.setTitle(doc.get("title"));
            ql.setSummary(doc.get("_static_summary"));
            ql.setID(doc.get("_qlkey"));
            Field[] keywordFields = doc.getFields("_orig_keywords");
            Keywords kw = new Keywords();
            for (int j = 0; j < keywordFields.length; ++j) {
                Keyword kwrd = new Keyword();
                kwrd.setValue(keywordFields[j].stringValue());
                kw.addKeyword(kwrd);
            }
            ql.setKeywords(kw);
            qls.addQuickLink(ql);
        }
        return qls;
    }

    public void writeQuicklinks(OutputStream os) throws IOException {
        IQuickLinks qls = this.getQuicklinks();
        String serialized = qls.serialize();
        os.write(serialized.getBytes("UTF-8"));
        os.flush();
    }

    private QuicklinksReader(String collectionId) throws QuicklinksReaderInstantiationException {
        try {
            ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
            CollectionConfiguration collectionConfig = configManager.getCollection(collectionId);
            this.indexReader = IndexReader.open((String)collectionConfig.getIndexPath(IndexDescriptor.IndexType.QuickLink));
        }
        catch (Exception e) {
            throw new QuicklinksReaderInstantiationException(e);
        }
    }
}

