/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.quicklinks.index;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationRequest;
import com.ibm.es.nuvo.quicklinks.index.QuicklinksWriter;
import java.io.IOException;
import java.io.InputStream;

public class ImportQuicklinkRequest
implements ConfigurationRequest {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private InputStream is;

    public ImportQuicklinkRequest(InputStream is) {
        this.is = is;
    }

    public ConfigurationRequest process(String collectionId) throws Exception {
        QuicklinksWriter qlWriter = null;
        try {
            qlWriter = QuicklinksWriter.open(collectionId);
            qlWriter.addQuicklinks(this.is);
        }
        catch (Exception e) {
            Message msg = new Message("A0158E.UNABLE_TO_IMPORT_QUICKLINKS");
            msg.addArgument(collectionId);
            throw new ExtendedException(msg, (Throwable)e);
        }
        finally {
            if (qlWriter != null) {
                try {
                    qlWriter.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }
}

