/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.quicklinks.factory;

import com.ibm.es.nuvo.quicklinks.factory.IKeyword;
import com.ibm.es.nuvo.quicklinks.factory.IKeywords;
import com.ibm.es.nuvo.quicklinks.factory.IPageLanguage;
import com.ibm.es.nuvo.quicklinks.factory.IPageLanguages;
import com.ibm.es.nuvo.quicklinks.factory.IQuickLink;
import com.ibm.es.nuvo.quicklinks.factory.IQuickLinks;
import com.ibm.es.nuvo.quicklinks.factory.Keyword;
import com.ibm.es.nuvo.quicklinks.factory.Keywords;
import com.ibm.es.nuvo.quicklinks.factory.PageLanguage;
import com.ibm.es.nuvo.quicklinks.factory.PageLanguages;
import com.ibm.es.nuvo.quicklinks.factory.QuickLink;
import com.ibm.es.nuvo.quicklinks.factory.QuickLinks;
import com.ibm.es.nuvo.quicklinks.factory.SAXQuickLinksFactory;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.xml.sax.InputSource;

public class QuickLinksFactory {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static QuickLinksFactory factory = new QuickLinksFactory();

    public static QuickLinksFactory getQuickLinksFactory() {
        return factory;
    }

    private QuickLinksFactory() {
    }

    public IQuickLinks createQuickLinks() {
        return new QuickLinks();
    }

    public IQuickLink createQuickLink() {
        return new QuickLink();
    }

    public IPageLanguages createPageLanguages() {
        return new PageLanguages();
    }

    public IPageLanguage createPageLanguage() {
        return new PageLanguage();
    }

    public IKeywords createKeywords() {
        return new Keywords();
    }

    public IKeyword createKeyword() {
        return new Keyword();
    }

    public IQuickLinks createFromXML(InputStream stream) {
        SAXQuickLinksFactory saxFactory = new SAXQuickLinksFactory();
        IQuickLinks quickLinks = (IQuickLinks)saxFactory.mapXMLFrom(stream);
        return quickLinks;
    }

    public IQuickLinks createFromXML(Reader reader) {
        SAXQuickLinksFactory saxFactory = new SAXQuickLinksFactory();
        IQuickLinks quickLinks = (IQuickLinks)saxFactory.mapXMLFrom(reader);
        return quickLinks;
    }

    public IQuickLinks createFromXML(String xmlRequest) {
        try {
            SAXQuickLinksFactory saxFactory = new SAXQuickLinksFactory();
            IQuickLinks quickLinks = (IQuickLinks)saxFactory.mapXMLFrom(new InputSource(new StringReader(xmlRequest)));
            return quickLinks;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

