/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.quicklinks.factory;

import com.ibm.es.nuvo.quicklinks.factory.IKeyword;
import com.ibm.es.nuvo.quicklinks.factory.IKeywords;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Keywords
implements IKeywords {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String Element_keywords = "keywords";
    public static final String Attribute_language = "language";
    private List<IKeyword> keywords;
    private String language;

    @Override
    public void setKeywords(List<IKeyword> list) {
        this.keywords = list;
    }

    @Override
    public IKeyword[] getKeywords() {
        if (this.keywords == null || 0 == this.keywords.size()) {
            return null;
        }
        IKeyword[] array = this.keywords.toArray(new IKeyword[this.keywords.size()]);
        return array;
    }

    @Override
    public Reader getReader() {
        return new KeywordReader();
    }

    @Override
    public void addKeyword(IKeyword keyword) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<IKeyword>();
        }
        this.keywords.add(keyword);
    }

    @Override
    public String serialize() {
        XMLTagger tagger = new XMLTagger(true);
        this.serialize(tagger);
        return tagger.getXML();
    }

    public void serialize(XMLTagger tagger) {
        tagger.openStartElement(Element_keywords);
        if (this.getLanguage() != null) {
            tagger.writeAttr(Attribute_language, this.getLanguage());
        }
        tagger.closeTag();
        if (this.keywords != null && this.keywords.size() > 0) {
            Iterator<IKeyword> it = this.keywords.iterator();
            while (it.hasNext()) {
                tagger.writeText(it.next().serialize(), false);
            }
            tagger.writeEndline();
        }
        tagger.endElement(Element_keywords);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String string) {
        this.language = string;
    }

    private class KeywordReader
    extends Reader {
        private int currentKeywordIndex = 0;
        private int currentKeywordOffset = 0;

        public int read(char[] buf, int offset, int len) {
            int currentBufferOffset = offset;
            if (Keywords.this.keywords.size() == 0) {
                return -1;
            }
            int numRead = -1;
            int prevKeywordIndex = -1;
            String currentKeyword = null;
            while (numRead < len && this.currentKeywordIndex != Keywords.this.keywords.size()) {
                if (prevKeywordIndex != this.currentKeywordIndex) {
                    currentKeyword = ((IKeyword)Keywords.this.keywords.get(this.currentKeywordIndex)).getValue();
                    prevKeywordIndex = this.currentKeywordIndex;
                }
                if (this.currentKeywordOffset < currentKeyword.length()) {
                    buf[currentBufferOffset++] = currentKeyword.charAt(this.currentKeywordOffset++);
                    ++numRead;
                    continue;
                }
                this.currentKeywordOffset = 0;
                ++this.currentKeywordIndex;
            }
            return numRead;
        }

        public void close() {
        }
    }
}

