/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.plugin;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.configuration.SystemSettings;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.plugin.MetadataPlugin;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataPluginClassLoader
extends URLClassLoader {
    private URL pluginDirectoryURL = null;
    private MetadataPlugin metadataPlugin = null;

    public MetadataPluginClassLoader() {
        super(new URL[0], MetadataPluginClassLoader.class.getClassLoader());
        SettingsConfigurationManager settingsConfigMgr = SettingsConfigurationManager.getConfigurationManager();
        SystemSettings systemSettings = (SystemSettings)settingsConfigMgr.getSettings(SettingsConfigurationManager.SettingsType.SystemSettings);
        String directory = systemSettings.getMetadataPluginDirectory();
        if (directory != null) {
            if (!(directory = directory.replaceAll("\\\\", "/")).endsWith("/")) {
                directory = directory.concat("/");
            }
            try {
                this.pluginDirectoryURL = new URL("file", "", directory);
            }
            catch (Exception e) {
                this.pluginDirectoryURL = null;
                Loggers.logger.log(Level.WARNING, new Message("P7000W.CANNOT_PROCESS_MD_PLUGIN_DIRECTORY", directory, e.getMessage()));
            }
            super.addURL(this.pluginDirectoryURL);
        }
    }

    private Class<?> findMetadataPluginClass() {
        ArrayList matchingClasses;
        block13: {
            if (this.pluginDirectoryURL == null) {
                return null;
            }
            matchingClasses = new ArrayList();
            Vector<Object> tempFileList = new Vector<Object>();
            try {
                Object[] fileList;
                File pluginDirectoryFile = new File(this.pluginDirectoryURL.getFile());
                if (!pluginDirectoryFile.isDirectory() || (fileList = pluginDirectoryFile.list()) == null) break block13;
                Arrays.sort(fileList);
                for (Object file : fileList) {
                    Enumeration<Object> fileEntries;
                    block14: {
                        tempFileList.clear();
                        fileEntries = tempFileList.elements();
                        if (((String)file).endsWith(".jar")) {
                            try {
                                URL u = new URL("jar", "", this.pluginDirectoryURL + (String)file + "!/");
                                super.addURL(u);
                                JarURLConnection uc = (JarURLConnection)u.openConnection();
                                JarFile jf = uc.getJarFile();
                                fileEntries = jf.entries();
                                break block14;
                            }
                            catch (Throwable e) {
                                Loggers.logger.log(Level.WARNING, new Message("P7001W.CANNOT_PROCESS_MD_PLUGIN_JAR", file, e.getMessage()));
                                continue;
                            }
                        }
                        if (((String)file).endsWith(".class")) {
                            tempFileList.add(file);
                            fileEntries = tempFileList.elements();
                        }
                    }
                    while (fileEntries.hasMoreElements()) {
                        String fileName = fileEntries.nextElement().toString();
                        if (!fileName.endsWith(".class")) continue;
                        String theClassName = fileName.replaceAll("/", ".").substring(0, fileName.length() - 6);
                        Class<?> theClass = null;
                        try {
                            theClass = this.loadClass(theClassName);
                        }
                        catch (Throwable e) {
                            Loggers.logger.log(Level.WARNING, new Message("P7002W.CANNOT_PROCESS_MD_PLUGIN_CLASS", fileName, e.getMessage()));
                            continue;
                        }
                        if (theClass.isInterface()) continue;
                        for (Class<?> classInterface : theClass.getInterfaces()) {
                            if (!classInterface.getName().equals(MetadataPlugin.class.getName())) continue;
                            matchingClasses.add(theClass);
                        }
                    }
                }
            }
            catch (Exception e) {
                Loggers.logger.log(Level.WARNING, new Message("P7000W.CANNOT_PROCESS_MD_PLUGIN_DIRECTORY", this.pluginDirectoryURL.getFile(), e.getMessage()));
            }
        }
        if (matchingClasses.size() > 1) {
            Loggers.logger.log(Level.WARNING, new Message("P7003W.FOUND_MULTIPLE_MD_PLUGINS", ((Object)matchingClasses).toString(), ((Class)matchingClasses.get(0)).toString()));
        }
        return matchingClasses.size() > 0 ? (Class)matchingClasses.get(0) : null;
    }

    public final MetadataPlugin getMetadataPlugin() {
        Class<?> metadataPluginClass;
        if (this.metadataPlugin == null && (metadataPluginClass = this.findMetadataPluginClass()) != null) {
            try {
                this.metadataPlugin = (MetadataPlugin)metadataPluginClass.newInstance();
            }
            catch (Throwable e) {
                this.metadataPlugin = null;
                Loggers.logger.log(Level.WARNING, new Message("P7004W.CANNOT_INSTANTIATE_MD_PLUGIN_CLASS", metadataPluginClass.getName(), e.getMessage()));
            }
            if (this.metadataPlugin != null) {
                try {
                    boolean initResult = this.metadataPlugin.init();
                    if (!initResult) {
                        this.metadataPlugin = null;
                        Loggers.logger.log(Level.WARNING, new Message("P7005W.MD_PLUGIN_INIT_FALSE", metadataPluginClass.getName()));
                    }
                }
                catch (Throwable e) {
                    this.metadataPlugin = null;
                    Loggers.logger.log(Level.WARNING, new Message("P7006W.MD_PLUGIN_INIT_ERROR", metadataPluginClass.getName(), e.getMessage()));
                }
            }
            if (this.metadataPlugin != null) {
                Loggers.logger.log(Level.INFO, new Message("P7007I.USING_MD_PLUGIN_CLASS", this.metadataPlugin.getClass().getName()));
            }
        }
        return this.metadataPlugin;
    }

    public final void clearMetadataPlugin() {
        if (this.metadataPlugin != null) {
            try {
                boolean destroyResult = this.metadataPlugin.destroy();
                if (!destroyResult) {
                    Loggers.logger.log(Level.WARNING, new Message("P7008W.MD_PLUGIN_DESTROY_FALSE", this.metadataPlugin.getClass().getName()));
                }
            }
            catch (Throwable e) {
                Loggers.logger.log(Level.WARNING, new Message("P7009W.MD_PLUGIN_DESTROY_ERROR", this.metadataPlugin.getClass().getName(), e.getMessage()));
            }
            this.metadataPlugin = null;
        }
    }
}

