/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.xml;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.parser.AbstractTextParser;
import com.ibm.es.nuvo.parser.MalformedEncodingException;
import com.ibm.es.nuvo.parser.MalformedFormatException;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.ParserIOException;
import com.ibm.es.nuvo.parser.xml.NativeSAXHandlerException;
import com.ibm.es.nuvo.parser.xml.NativeXMLSAXHandler;
import com.ibm.es.nuvo.util.StringUtils;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends AbstractTextParser {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String CONTENT_TYPE = "text/xml";
    private NativeXMLSAXHandler saxHandler;
    private SAXParser saxParser;
    private static SAXParserFactory saxParserFactory = null;
    private static Object saxParserFactoryLock = new Object();

    public void open(Properties p) {
        try {
            super.open(p);
            this.saxHandler = new NativeXMLSAXHandler(p);
            this.saxParser = XMLParser.newSAXParser();
            this.saxParser.getXMLReader().setContentHandler(this.saxHandler);
            this.saxParser.getXMLReader().setEntityResolver(this.saxHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseText(String uri, Metadata metadata, InputSource input, ParserHandler parserHandler) throws ParserException {
        String url = null;
        String charSet = null;
        String knownCharSet = null;
        if (metadata != null) {
            metadata.set("doctype", CONTENT_TYPE);
            url = metadata.get("URL");
            charSet = metadata.get("Charset");
            knownCharSet = metadata.get("KnownCharset");
        }
        if (StringUtils.noData(url)) {
            url = uri;
        }
        this.saxHandler.newDocument(uri, url, metadata);
        this.saxHandler.setParserHandler(parserHandler);
        try {
            if (!StringUtils.noData(knownCharSet)) {
                metadata.set("charset", knownCharSet);
            } else if (!StringUtils.noData(charSet)) {
                metadata.set("charset", charSet);
            }
            this.saxParser.parse(input, (DefaultHandler)this.saxHandler);
        }
        catch (CharConversionException e) {
            throw new MalformedEncodingException(uri, (Throwable)e);
        }
        catch (IOException e) {
            throw new ParserIOException(uri, (Throwable)e);
        }
        catch (NativeSAXHandlerException e) {
            throw e.getCause();
        }
        catch (SAXException e) {
            throw new MalformedFormatException(uri, (Throwable)e);
        }
        catch (Throwable e) {
            throw new ParserException(uri, e);
        }
    }

    public void parseText(String uri, Metadata metadata, Reader input, ParserHandler parserHandler) throws ParserException {
        this.parseText(uri, metadata, new InputSource(input), parserHandler);
    }

    public void parseText(String uri, Metadata metadata, InputStream input, ParserHandler parserHandler, String detectedCharset) throws ParserException {
        this.parseText(uri, metadata, new InputSource(input), parserHandler);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseStaticResources() {
        Object object = saxParserFactoryLock;
        synchronized (object) {
            saxParserFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SAXParser newSAXParser() throws Exception {
        try {
            Object object = saxParserFactoryLock;
            synchronized (object) {
                if (saxParserFactory == null) {
                    saxParserFactory = SAXParserFactory.newInstance();
                    saxParserFactory.setNamespaceAware(true);
                }
                return saxParserFactory.newSAXParser();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

