/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.xml;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.Segment;
import com.ibm.es.nuvo.parser.XMLTagInfo;
import com.ibm.es.nuvo.parser.XMLTextBuffers;
import com.ibm.es.nuvo.parser.xml.NativeSAXHandlerException;
import com.ibm.es.nuvo.util.StringUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NativeXMLSAXHandler
extends DefaultHandler {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String HANDLE_EXTERNAL_FILES_PROP = "handleExternalFiles";
    public static final String HANDLE_SKIPPED_ENTITIES_PROP = "handleSkippedEntities";
    public static final String TITLE_TAGNAME_PROP = "titleTagNameList";
    private String crawlURI;
    private boolean ignoreExternalFiles = true;
    private boolean ignoreSkippedEntities = true;
    private Metadata metadata;
    private ParserHandler parserHandler;
    private int nextSerialNumber;
    private Stack<XMLTagInfo> tagStack = new Stack();
    private XMLTextBuffers textBuffers;
    private XMLTagInfo titleTagInfo;
    private LinkedList<String> titleTagNameList = new LinkedList();
    private boolean titleSegmentSent;

    public NativeXMLSAXHandler(Properties properties) {
        if (properties != null) {
            String[] trimmedProp = new String[1];
            String property = properties.getProperty(TITLE_TAGNAME_PROP);
            if (property == null) {
                this.titleTagNameList.add("title");
            } else {
                this.titleTagNameList = null;
                if (!StringUtils.noData(property, trimmedProp)) {
                    try {
                        int k;
                        String[] sa = trimmedProp[0].split(",", -1);
                        LinkedList<String> list = new LinkedList<String>();
                        int n = k = sa == null ? 0 : sa.length;
                        for (int j = 0; j < k; ++j) {
                            if (sa[j] == null || sa[j].length() <= 0) continue;
                            sa[j] = sa[j].trim();
                            if (sa[j] == null || sa[j].length() <= 0) continue;
                            list.add(sa[j]);
                        }
                        if (list.size() > 0) {
                            this.titleTagNameList = list;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (!StringUtils.noData(properties.getProperty(HANDLE_EXTERNAL_FILES_PROP), trimmedProp)) {
                boolean bl = this.ignoreExternalFiles = !trimmedProp[0].equalsIgnoreCase("read");
            }
            if (!StringUtils.noData(properties.getProperty(HANDLE_SKIPPED_ENTITIES_PROP), trimmedProp)) {
                this.ignoreSkippedEntities = !trimmedProp[0].equalsIgnoreCase("reject");
            }
        }
    }

    public void newDocument(String crawlURI_, String fieldSearchableURL_, Metadata metadata_) {
        this.crawlURI = crawlURI_;
        this.metadata = metadata_;
    }

    public void setParserHandler(ParserHandler handler) {
        this.parserHandler = handler;
    }

    public void setDocumentLocator(Locator locator_) {
    }

    public void startDocument() throws SAXException {
        this.tagStack.clear();
        this.textBuffers = new XMLTextBuffers();
        this.nextSerialNumber = 1;
        this.titleSegmentSent = false;
        try {
            this.parserHandler.startDocument(this.crawlURI, this.metadata);
            this.parserHandler.addSegment(Segment.newSegment("doctype", "text/xml", 327680));
            this.parserHandler.addXMLTagInfo(new XMLTagInfo(this.textBuffers));
        }
        catch (ParserException e) {
            throw new NativeSAXHandlerException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.parserHandler.addXMLTagInfo(new XMLTagInfo(this.textBuffers));
            this.parserHandler.endDocument();
        }
        catch (ParserException e) {
            throw new NativeSAXHandlerException(e);
        }
    }

    public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        try {
            boolean overLimit = this.textBuffers.getTruncaterRemainingChars() <= 0L;
            int serialNumberForThisTag = this.nextSerialNumber++;
            if (!overLimit) {
                // empty if block
            }
            XMLTagInfo xtp = new XMLTagInfo(serialNumberForThisTag);
            xtp.setDepth(this.tagStack.size());
            xtp.setTagName(localName);
            xtp.setTagTextStartPos(this.textBuffers.lengthOfXMLBuffer(0));
            xtp.setOverLimit(overLimit);
            this.tagStack.push(xtp);
            this.checkForTitle(localName, xtp);
            if (!xtp.isOverLimit()) {
                for (int j = 0; j < atts.getLength(); ++j) {
                    String name = atts.getLocalName(j);
                    String value = atts.getValue(j);
                    XMLTagInfo.Attribute a = xtp.addAttribute();
                    a.setName(name);
                    if (this.textBuffers.lengthOfXMLBuffer(1) > 0) {
                        this.textBuffers.appendToXMLBuffer(1, "\n\n");
                    }
                    int startPos = this.textBuffers.lengthOfXMLBuffer(1);
                    a.setValueStartPos(startPos);
                    this.textBuffers.appendToXMLBuffer(1, value);
                    int endPos = this.textBuffers.lengthOfXMLBuffer(1);
                    a.setValueLength(endPos - startPos);
                    String valueString = ((Object)this.textBuffers.getXMLBuffer(1).subSequence(startPos, endPos)).toString();
                    if (valueString != null && valueString.length() > 0) {
                        valueString = valueString.trim();
                    }
                    try {
                        Long l = Long.parseLong(valueString);
                        a.setValue(l);
                        continue;
                    }
                    catch (Exception e) {
                        try {
                            Double d = Double.parseDouble(valueString);
                            a.setValue(d);
                            continue;
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                }
            }
            if (!overLimit) {
                this.textBuffers.addToCharsUsedInNames(xtp.getNumberOfCharsInNames());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        try {
            XMLTagInfo xtp = this.tagStack.pop();
            if (!xtp.getTagName().equals(localName)) {
                throw new SAXException("Well-formedness violation: tag name mismatch: " + xtp.getTagName() + ", " + localName);
            }
            if (!xtp.isOverLimit()) {
                xtp.setLastDescendant(this.nextSerialNumber - 1);
                xtp.setTagTextEnd(this.textBuffers.lengthOfXMLBuffer(0));
                this.parserHandler.addXMLTagInfo(xtp);
                if (xtp == this.titleTagInfo) {
                    this.extractTitle();
                    this.titleTagInfo = null;
                }
            }
        }
        catch (EmptyStackException e) {
            throw new NativeSAXHandlerException(new ParserException(uri, (Throwable)e));
        }
        catch (ParserException e) {
            throw new NativeSAXHandlerException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        long remChars = this.textBuffers.getTruncaterRemainingChars();
        if (remChars < (long)length) {
            length = (int)remChars;
        }
        if (length > 0) {
            XMLTagInfo currentTag = null;
            if (this.tagStack != null && !this.tagStack.empty()) {
                currentTag = this.tagStack.peek();
            }
            try {
                if (currentTag != null && !currentTag.isWhitespaceSeparatorPrepended() && this.textBuffers.lengthOfXMLBuffer(0) > 0) {
                    this.textBuffers.appendToXMLBuffer(0, " ");
                    currentTag.setWhitespaceSeparatorPrepended(true);
                }
                this.textBuffers.appendToXMLBuffer(0, new String(ch, start, length));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
        if (this.ignoreExternalFiles) {
            InputSource inputSource = new InputSource(systemID);
            inputSource.setPublicId(publicID);
            inputSource.setCharacterStream(new StringReader(" "));
            return inputSource;
        }
        return null;
    }

    public void skippedEntity(String name) throws SAXException {
        if (!this.ignoreSkippedEntities) {
            throw new SAXException("Skipped entity: " + name);
        }
    }

    private void checkForTitle(String tagName, XMLTagInfo tagInfo) {
        if (!this.titleSegmentSent && this.titleTagInfo == null && this.titleTagNameList != null) {
            for (String listEntry : this.titleTagNameList) {
                if (!listEntry.equalsIgnoreCase(tagName)) continue;
                this.titleTagInfo = tagInfo;
                return;
            }
        }
    }

    private void extractTitle() throws ParserException {
        if (this.titleTagInfo == null) {
            return;
        }
        this.parserHandler.addSegment(Segment.newSegment("title", this.textBuffers.getXMLBuffer(0), this.titleTagInfo.getTagTextStartPos(), this.titleTagInfo.getTagTextLength(), 327680));
        this.titleSegmentSent = true;
    }
}

