/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.transform.oi.fenced.worker;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.parser.transform.oi.fenced.worker.FencedOITransformationWorker;
import com.ibm.es.nuvo.util.remoteprocess.RemoteProcessException;
import com.ibm.es.nuvo.util.remoteprocess.worker.Worker;
import com.ibm.es.nuvo.util.remoteprocess.worker.fenced.FencedWorkerFactory;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class FencedOITransformationWorkerFactory
implements FencedWorkerFactory {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final ProcessBuilder builder;
    private static final String EXECUTABLE_UNIX = "OutsideInProcess";
    private static final String EXECUTABLE_WINDOWS = "OutsideInProcess.exe";
    private static final String SEARCHEXPORT_CONFIG = "searchexport.cfg";
    private static final String HTMLEXPORT_CONFIG = "htmlexport.cfg";
    private static final String TEMPFILE_PREFIX = "frp";
    private static final String className = FencedOITransformationWorkerFactory.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);

    public FencedOITransformationWorkerFactory() throws RemoteProcessException {
        String sourceName = this.getClass().getName();
        String methodName = "<init>";
        tracer.entering(sourceName, "<init>");
        GlobalConfiguration config = GlobalConfiguration.getConfiguration();
        String stellentPath = config.getStellentPath();
        String stellentExecutable = config.isWindows() ? EXECUTABLE_WINDOWS : EXECUTABLE_UNIX;
        File stellentPathFile = new File(stellentPath);
        File stellentExecutableFile = new File(stellentPathFile, stellentExecutable);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "StellentExecutable is : " + stellentExecutableFile);
        }
        if (!stellentPathFile.exists() || !stellentExecutableFile.exists()) {
            Message m = new Message("P0001E.CANNOT_LOCATE_STELLENT");
            m.addArgument(stellentExecutable);
            throw new RemoteProcessException(m);
        }
        File searchExportConfig = new File(stellentPathFile, SEARCHEXPORT_CONFIG);
        File htmlExportConfig = new File(stellentPathFile, HTMLEXPORT_CONFIG);
        if (!searchExportConfig.exists() || searchExportConfig.isDirectory()) {
            Message m = new Message("G0053E.SYSTEM_MISSING_FILE");
            m.addArgument(searchExportConfig.getPath());
            throw new RemoteProcessException(m);
        }
        if (!htmlExportConfig.exists() || htmlExportConfig.isDirectory()) {
            Message m = new Message("G0053E.SYSTEM_MISSING_FILE");
            m.addArgument(htmlExportConfig.getPath());
            throw new RemoteProcessException(m);
        }
        try {
            String tempDirPath = new File(config.getTempDirectory()).getCanonicalPath();
            String stellentExecutablePath = stellentExecutableFile.getCanonicalPath();
            String searchExportConfigPath = searchExportConfig.getCanonicalPath();
            String htmlExportConfigPath = htmlExportConfig.getCanonicalPath();
            this.builder = new ProcessBuilder(stellentExecutablePath, tempDirPath, TEMPFILE_PREFIX, searchExportConfigPath, htmlExportConfigPath);
        }
        catch (IOException ioe) {
            Message m = new Message("P0002E.CANNOT_START_STELLENT");
            throw new RemoteProcessException(m, (Throwable)ioe);
        }
        Map<String, String> environment = this.builder.environment();
        try {
            if (!config.isWindows()) {
                String libpath;
                if (config.isLinux()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "The Transformation worker will be initialized for Linux...");
                    }
                    libpath = (libpath = System.getenv("LD_LIBRARY_PATH")) == null ? stellentPathFile.getCanonicalPath() : libpath + File.pathSeparator + stellentPathFile.getCanonicalPath();
                    environment.put("LD_LIBRARY_PATH", libpath);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "LD_LIBRARY_PATH is set as : " + libpath);
                    }
                } else if (config.isAIX()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "The Transformation worker will be initialized for AIX...");
                    }
                    libpath = (libpath = System.getenv("LIBPATH")) == null ? stellentPathFile.getCanonicalPath() : libpath + File.pathSeparator + stellentPathFile.getCanonicalPath();
                    environment.put("LIBPATH", libpath);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "LIBPATH is set as : " + libpath);
                    }
                }
                String path = System.getenv("PATH");
                path = path == null ? stellentPathFile.getCanonicalPath() : path + File.pathSeparator + stellentPathFile.getCanonicalPath();
                environment.put("PATH", path);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "PATH is set as : " + path);
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "The Transformation worker will be initialized for Windows...");
            }
        }
        catch (IOException ioe) {
            Message m = new Message("P0002E.CANNOT_START_STELLENT");
            throw new RemoteProcessException(m, (Throwable)ioe);
        }
        tracer.exiting(sourceName, "<init>");
    }

    public Worker createWorker(Properties props) throws RemoteProcessException {
        String sourceName = this.getClass().getName();
        String methodName = "createWorker";
        tracer.entering(sourceName, "createWorker");
        FencedOITransformationWorker retVal = null;
        try {
            if (logger.isLoggable(Level.FINE)) {
                StringBuilder cmdBuilder = new StringBuilder();
                for (String arg : this.builder.command()) {
                    cmdBuilder.append(arg).append(' ');
                }
                logger.log(Level.FINE, "Starting subprocess.. Command: " + cmdBuilder.toString().trim());
            }
            Process process = this.builder.start();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Finished launching subprocess.");
            }
            retVal = new FencedOITransformationWorker(process, props);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "A worker has been initialized.");
            }
        }
        catch (IOException ioe) {
            throw new RemoteProcessException(ioe);
        }
        tracer.exiting(sourceName, "createWorker");
        return retVal;
    }
}

