/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.transform.oi.fenced.worker;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.parser.transform.oi.Format;
import com.ibm.es.nuvo.parser.transform.oi.HandledStellentErrorCodes;
import com.ibm.es.nuvo.parser.transform.oi.OutsideInClientException;
import com.ibm.es.nuvo.util.remoteprocess.RemoteProcessException;
import com.ibm.es.nuvo.util.remoteprocess.worker.WorkerTimeoutException;
import com.ibm.es.nuvo.util.remoteprocess.worker.fenced.AbstractFencedWorker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FencedOITransformationWorker
extends AbstractFencedWorker {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = FencedOITransformationWorker.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    private static int MAX_PROCESSABLE_DOCUMENTS = 2000;
    public static final String MAX_PROCESSABLE_DOCUMENTS_PROPS = "MaxProcessableDocuments";
    private static final String DUMMY_EMPTY_SEARCHML = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><searchml/>";
    private int maxProcessableDocuments = MAX_PROCESSABLE_DOCUMENTS;
    private int numberOfProcessedDocuments;

    FencedOITransformationWorker(Process process) throws RemoteProcessException {
        this(process, new Properties());
    }

    FencedOITransformationWorker(Process process, Properties props) throws RemoteProcessException {
        super(process);
        if (props.containsKey("BufferSize")) {
            try {
                this.bufferSize = Integer.parseInt(props.getProperty("BufferSize"));
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Buffer size is overwritten with " + this.bufferSize);
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (props.containsKey("CacheInitSize")) {
            try {
                this.initCacheSize = Integer.parseInt(props.getProperty("CacheInitSize"));
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Cache init size is overwritten with " + this.initCacheSize);
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (props.containsKey("ChacheThreshold")) {
            try {
                this.thresholdCasheSize = Integer.parseInt(props.getProperty("ChacheThreshold"));
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Cache threshold size is overwritten with " + this.thresholdCasheSize);
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (props.containsKey(MAX_PROCESSABLE_DOCUMENTS_PROPS)) {
            try {
                this.maxProcessableDocuments = Integer.parseInt(props.getProperty(MAX_PROCESSABLE_DOCUMENTS_PROPS));
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Max processable document is overwritten with " + this.maxProcessableDocuments);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.initCacheSize > this.thresholdCasheSize) {
            throw new IllegalStateException("Cache threshold must be larger than Cache init size.");
        }
        this.numberOfProcessedDocuments = 0;
    }

    @Override
    public InputStream process(InputStream srcInput, Map<String, String> props, long timeout) throws WorkerTimeoutException, RemoteProcessException {
        String methodName = "process";
        tracer.entering(className, "process");
        String formatStr = null;
        Format format = null;
        if (!props.containsKey("format")) {
            throw new IllegalArgumentException("An property \"format\" is required.");
        }
        formatStr = props.get("format");
        format = this.getFormat(formatStr);
        InputStream retVal = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Initializing Transformation task...");
        }
        TransformTask transformTask = new TransformTask(srcInput, format);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Submitting the Transformation task to the Executor...");
        }
        Future<InputStream> f = this.executorService.submit(transformTask);
        try {
            retVal = f.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RemoteProcessException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof OutsideInClientException) {
                OutsideInClientException ce = (OutsideInClientException)e.getCause();
                if (ce.getCode() == HandledStellentErrorCodes.SCCERR_EMPTYFILE.getCode()) {
                    try {
                        retVal = new ByteArrayInputStream(DUMMY_EMPTY_SEARCHML.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException uee) {}
                }
                throw ce;
            }
            throw new RemoteProcessException(e);
        }
        catch (TimeoutException e) {
            f.cancel(true);
            throw new WorkerTimeoutException(e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "The submitted Transformation task conpleted.");
        }
        ++this.numberOfProcessedDocuments;
        tracer.exiting(className, "process");
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream transformActual(InputStream srcInput, Format format) throws OutsideInClientException, RemoteProcessException {
        String methodName = "transformActual";
        tracer.entering(className, "transformActual");
        long retCode = HandledStellentErrorCodes.SCCERR_OK.getCode();
        BufferedInputStream retVal = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Sending a command to process documents against the subprocess. Format: " + format.getName());
        }
        switch (format) {
            case SEARCH_ML3: {
                this.sendMessage(3);
                break;
            }
            case SEARCH_HTML: {
                this.sendMessage(4);
                break;
            }
            case HTML: {
                this.sendMessage(5);
                break;
            }
            default: {
                this.sendMessage(3);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Sending the document content to the subprocess.");
        }
        byte[] buf = new byte[this.bufferSize];
        try {
            int len = 0;
            int alreadyRead = 0;
            while ((len = srcInput.read(buf, alreadyRead, this.bufferSize - alreadyRead)) > -1) {
                if ((alreadyRead += len) != this.bufferSize) continue;
                this.sendDataSize(this.bufferSize);
                this.dos.write(buf, 0, this.bufferSize);
                alreadyRead = 0;
            }
            if (alreadyRead > 0) {
                this.sendDataSize(alreadyRead);
                this.dos.write(buf, 0, alreadyRead);
                this.dos.flush();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Sending the document content completed. Sending the completion message to the subprocess.");
            }
            this.sendMessage(0);
        }
        catch (IOException ioe) {
            throw new RemoteProcessException(ioe);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Reading the processed document content from the subprocess.");
        }
        try {
            File tempFile = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.initCacheSize);
            OutputStream bos = baos;
            boolean isExceeded = false;
            try {
                int totalLength = 0;
                int contentSize = this.readMessage();
                while (contentSize > 0) {
                    int actualRead;
                    for (int alreadyReadSize = 0; alreadyReadSize < contentSize; alreadyReadSize += actualRead) {
                        int restSize = contentSize - alreadyReadSize;
                        int dataSize = restSize > this.bufferSize ? this.bufferSize : restSize;
                        actualRead = this.dis.read(buf, 0, dataSize);
                        if (actualRead == -1) {
                            Message message = new Message("G0147E.WORKERPROCESS_COMMUNICATION_FAILED");
                            throw new RemoteProcessException(message);
                        }
                        if (!isExceeded && actualRead + totalLength > this.thresholdCasheSize) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "The size of the processed document exceeded max cache size (" + this.thresholdCasheSize + "). A temporary files is created.");
                            }
                            bos.flush();
                            bos.close();
                            tempFile = this.createTempFile();
                            bos = new BufferedOutputStream(new FileOutputStream(tempFile));
                            bos.write(baos.toByteArray(), 0, baos.size());
                            isExceeded = true;
                        }
                        bos.write(buf, 0, actualRead);
                        totalLength += actualRead;
                    }
                    contentSize = this.readMessage();
                }
            }
            finally {
                bos.flush();
                bos.close();
            }
            retVal = !isExceeded ? new BufferedInputStream(new ByteArrayInputStream(baos.toByteArray())) : new BufferedInputStream(new TemporaryFileInputStream(tempFile));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Reading the processed document content completed.");
            }
            retCode = this.readMessage();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Return code (" + retCode + ") was received from the subprocess.");
            }
        }
        catch (FileNotFoundException e) {
            throw new RemoteProcessException(e);
        }
        catch (IOException ioe) {
            Message message = new Message("G0147E.WORKERPROCESS_COMMUNICATION_FAILED");
            throw new RemoteProcessException(message, (Throwable)ioe);
        }
        catch (Throwable t) {
            throw new RemoteProcessException(t);
        }
        if (retCode != HandledStellentErrorCodes.SCCERR_OK.getCode()) {
            throw new OutsideInClientException(retCode);
        }
        tracer.exiting(className, "transformActual");
        return retVal;
    }

    private File createTempFile() throws IOException {
        File tempFile = File.createTempFile("tsc_", ".tmp");
        tempFile.deleteOnExit();
        return tempFile;
    }

    private Format getFormat(String formatStr) {
        for (Format format : Format.values()) {
            if (!format.getName().equals(formatStr)) continue;
            return format;
        }
        return Format.SEARCH_ML3;
    }

    @Override
    public boolean isAvailable() throws RemoteProcessException {
        String methodName = "isAvailable";
        tracer.entering(className, "isAvailable");
        if (this.numberOfProcessedDocuments >= this.maxProcessableDocuments) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Processed documents exceeded number of max processable documents. Max processable documents:" + this.maxProcessableDocuments);
            }
            tracer.exiting(className, "isAvailable", false);
            return false;
        }
        boolean retVal = super.isAvailable();
        tracer.exiting(className, "isAvailable", retVal);
        return retVal;
    }

    private static class TemporaryFileInputStream
    extends FileInputStream {
        private final File tempFile;

        public void close() throws IOException {
            super.close();
            this.removeTemporaryFile();
        }

        protected void finalize() throws IOException {
            super.finalize();
            this.removeTemporaryFile();
        }

        public TemporaryFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this.tempFile = file;
        }

        private void removeTemporaryFile() {
            if (this.tempFile != null && this.tempFile.exists() && this.tempFile.isFile()) {
                this.tempFile.delete();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformTask
    implements Callable<InputStream> {
        private final InputStream srcInput;
        private final Format format;

        private TransformTask(InputStream srcInput, Format format) {
            this.srcInput = srcInput;
            this.format = format;
        }

        @Override
        public InputStream call() throws RemoteProcessException {
            InputStream retVal = null;
            retVal = FencedOITransformationWorker.this.transformActual(this.srcInput, this.format);
            return retVal;
        }
    }
}

