/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.transform.oi.fenced;

import com.ibm.es.nuvo.parser.transform.TransformationException;
import com.ibm.es.nuvo.parser.transform.TransformationManager;
import com.ibm.es.nuvo.parser.transform.oi.fenced.worker.FencedOITransformationWorkerFactory;
import com.ibm.es.nuvo.util.remoteprocess.RemoteProcessException;
import com.ibm.es.nuvo.util.remoteprocess.manager.WorkerManager;
import com.ibm.es.nuvo.util.remoteprocess.manager.fenced.FencedWorkerManager;
import com.ibm.es.nuvo.util.remoteprocess.worker.Worker;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class FencedOITransformationManager
implements TransformationManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static FencedOITransformationManager uniqueInstance = null;
    private static long DEFAULT_TIMEOUT = 300000L;
    private static int DEFAULT_RETRY_COUNT = 1;
    private static int DEFAULT_INITPOOLSIZE = 2;
    private static int DEFAULT_MAXPOOLSIZE = 4;
    private WorkerManager manager = null;
    private final long timeout;
    private final int retryCount;
    private final int maxPoolSize;
    private final int initPoolSize;

    private FencedOITransformationManager(long timeout, int retryCount, int initPoolSize, int maxPoolSize) {
        this.timeout = timeout;
        this.retryCount = retryCount;
        this.maxPoolSize = maxPoolSize;
        this.initPoolSize = initPoolSize;
    }

    public void initialize(Properties props) throws TransformationException {
    }

    public InputStream transform(InputStream srcInput, String format) throws TransformationException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("format", format);
        InputStream retVal = null;
        for (int i = 0; i < this.retryCount; ++i) {
            Worker aWorker = null;
            try {
                aWorker = this.manager.getAvailableWorker();
                retVal = aWorker.process(srcInput, props, this.timeout);
                this.manager.releaseWorker(aWorker);
                break;
            }
            catch (RemoteProcessException e) {
                if (aWorker != null) {
                    try {
                        this.manager.destroyWorker(aWorker);
                    }
                    catch (RemoteProcessException e2) {
                        throw new TransformationException(e2);
                    }
                }
                if (i + 1 != this.retryCount) continue;
                throw new TransformationException(e);
            }
        }
        return retVal;
    }

    public void terminate() throws TransformationException {
    }

    private void start() throws RemoteProcessException {
        if (this.manager != null) {
            throw new IllegalStateException(this.getClass().getName() + " has been initialized.");
        }
        FencedOITransformationWorkerFactory factory = new FencedOITransformationWorkerFactory();
        this.manager = new FencedWorkerManager(factory);
        this.manager.initialize(this.initPoolSize, this.maxPoolSize);
    }

    private void shutdown() throws RemoteProcessException {
        this.ensureInitialized();
        this.manager.terminate();
        this.manager = null;
    }

    private void ensureInitialized() throws IllegalStateException {
        if (this.manager == null) {
            throw new IllegalStateException("The instance is not initialized yet.");
        }
    }

    public static synchronized FencedOITransformationManager getInstance() throws RemoteProcessException {
        if (uniqueInstance == null) {
            uniqueInstance = new FencedOITransformationManager(DEFAULT_TIMEOUT, DEFAULT_RETRY_COUNT, DEFAULT_INITPOOLSIZE, DEFAULT_MAXPOOLSIZE);
            uniqueInstance.start();
        }
        return uniqueInstance;
    }

    public static void init(Properties props) throws RemoteProcessException {
        String initPoolStr;
        String retryStr;
        Properties workingProps = new Properties(props);
        String timeoutStr = workingProps.getProperty(ManagerProperty.TIMEOUT.getPropertyName());
        if (timeoutStr != null) {
            try {
                DEFAULT_TIMEOUT = Long.valueOf(timeoutStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((retryStr = workingProps.getProperty(ManagerProperty.RETRY_COUNT.getPropertyName())) != null) {
            try {
                DEFAULT_RETRY_COUNT = Integer.valueOf(retryStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((initPoolStr = workingProps.getProperty(ManagerProperty.INIT_POOLSIZE.getPropertyName())) != null) {
            try {
                DEFAULT_INITPOOLSIZE = Integer.valueOf(initPoolStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String maxPoolStr = workingProps.getProperty(ManagerProperty.MAX_POOLSIZE.getPropertyName());
        if (initPoolStr != null) {
            try {
                DEFAULT_MAXPOOLSIZE = Integer.valueOf(maxPoolStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void term() throws RemoteProcessException {
        try {
            if (uniqueInstance != null) {
                uniqueInstance.shutdown();
            }
        }
        finally {
            uniqueInstance = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ManagerProperty {
        MAX_POOLSIZE("MaxPoolSize"),
        INIT_POOLSIZE("InitPoolSize"),
        RETRY_COUNT("RetryCount"),
        TIMEOUT("Timeout");

        private final String name;

        public String getPropertyName() {
            return this.name;
        }

        private ManagerProperty(String name) {
            this.name = name;
        }
    }
}

