/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.transform.oi;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.parser.AbstractParser;
import com.ibm.es.nuvo.parser.MalformedEncodingException;
import com.ibm.es.nuvo.parser.MalformedFormatException;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.ParserIOException;
import com.ibm.es.nuvo.parser.SAXHandler;
import com.ibm.es.nuvo.parser.SAXHandlerException;
import com.ibm.es.nuvo.parser.transform.TransformationException;
import com.ibm.es.nuvo.parser.transform.TransformationManager;
import com.ibm.es.nuvo.parser.transform.TransformationService;
import com.ibm.es.nuvo.parser.transform.oi.OutsideInCleanser;
import com.ibm.es.nuvo.util.transform.TransformedDocumentInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OutsideInParser
extends AbstractParser {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private TransformationManager manager = null;
    private SAXParser parser;
    private SAXHandler handler;
    private Properties params;

    public void open(Properties p) throws ParserException {
        this.params = p;
        this.handler = this.createSAXHandler();
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new SAXInitException(e);
        }
        catch (SAXException e) {
            throw new SAXInitException(e);
        }
        try {
            this.manager = TransformationService.getManager();
            this.manager.initialize(this.params);
        }
        catch (TransformationException e) {
            throw new ParserException(new Message("P0003E.PARSE_OPERATION_ERROR"), (Throwable)e);
        }
    }

    public void doParse(String uri, Metadata metadata, InputStream input, ParserHandler parserHandler) throws ParserException {
        String url = null;
        if (metadata != null) {
            url = metadata.get("URL");
        }
        if (url == null || url.length() == 0) {
            url = uri;
        }
        this.handler.setURL(uri, url);
        this.handler.setMetadata(metadata);
        parserHandler = new OutsideInCleanser(parserHandler);
        this.handler.setParserHandler(parserHandler);
        TransformedDocumentInputStream tdin = null;
        try {
            InputSource in = null;
            tdin = new TransformedDocumentInputStream(input, "search-ml-3", this.manager);
            in = new InputSource(tdin);
            this.parser.parse(in, (DefaultHandler)this.handler);
        }
        catch (SAXHandlerException e) {
            throw e.getCause();
        }
        catch (SAXException e) {
            throw new MalformedFormatException(uri, (Throwable)e);
        }
        catch (CharConversionException e) {
            throw new MalformedEncodingException(uri, (Throwable)e);
        }
        catch (IOException e) {
            throw new ParserIOException(uri, (Throwable)e);
        }
        catch (Throwable e) {
            throw new ParserException(uri, e);
        }
        finally {
            if (tdin != null) {
                tdin.close();
            }
        }
    }

    public void close() throws ParserException {
        try {
            this.manager.terminate();
        }
        catch (TransformationException transformationException) {
            // empty catch block
        }
    }

    private static class SAXInitException
    extends ParserException {
        private static final long serialVersionUID = 1L;

        private SAXInitException(Throwable cause) {
            super(new Message("P0003E.PARSE_OPERATION_ERROR"), cause);
        }
    }
}

