/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.transform;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.parser.transform.TransformationException;
import com.ibm.es.nuvo.parser.transform.TransformationManager;
import com.ibm.es.nuvo.parser.transform.oi.fenced.FencedOITransformationManager;
import com.ibm.es.nuvo.util.remoteprocess.RemoteProcessException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TransformationService {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static boolean useStellent = false;
    private static String stellentPath = null;

    public static TransformationManager getManager() throws TransformationException {
        FencedOITransformationManager manager = null;
        if (useStellent) {
            try {
                manager = FencedOITransformationManager.getInstance();
            }
            catch (RemoteProcessException e) {
                throw new TransformationException(e);
            }
            return manager;
        }
        Message msg = new Message("P2600E.TRANSFORMATION_SERVICE_NOTAVAILABLE_ERROR");
        throw new TransformationException(msg);
    }

    public static void initialize(Properties props) throws TransformationException {
        Properties workingProps = new Properties(props);
        GlobalConfiguration config = GlobalConfiguration.getConfiguration();
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        try {
            useStellent = releaseInfo.getValueAsBoolean("System", "StellentEnabled", true);
            stellentPath = config.getStellentPath();
            TransformationService.prepareStellent(config, stellentPath);
        }
        catch (ExtendedException e) {
            Message msg = new Message("P2601E.START_TRANSFORMATION_SERVICE_ERROR");
            throw new TransformationException(msg, (Throwable)e);
        }
        if (useStellent) {
            try {
                Integer transformationMaxPoolSize = releaseInfo.getValueAsInt("System", "Max.TransformationPoolsize", 2);
                if (transformationMaxPoolSize != 0) {
                    workingProps.setProperty(FencedOITransformationManager.ManagerProperty.MAX_POOLSIZE.getPropertyName(), transformationMaxPoolSize.toString());
                }
            }
            catch (ExtendedException e1) {
                // empty catch block
            }
            try {
                Integer transformationInitPoolSize = releaseInfo.getValueAsInt("System", "Init.TransformationPoolsize", 2);
                if (transformationInitPoolSize != 0) {
                    workingProps.setProperty(FencedOITransformationManager.ManagerProperty.INIT_POOLSIZE.getPropertyName(), transformationInitPoolSize.toString());
                }
            }
            catch (ExtendedException e1) {
                // empty catch block
            }
            try {
                Long transformationTimeout = 1000L * (long)releaseInfo.getValueAsInt("System", "TransformationTimeout", 0);
                if (transformationTimeout != 0L) {
                    workingProps.setProperty(FencedOITransformationManager.ManagerProperty.TIMEOUT.getPropertyName(), transformationTimeout.toString());
                }
            }
            catch (ExtendedException e1) {
                // empty catch block
            }
            try {
                Integer transformationRetries = releaseInfo.getValueAsInt("System", "TransformationRetries", 0);
                if (transformationRetries != 0) {
                    workingProps.setProperty(FencedOITransformationManager.ManagerProperty.RETRY_COUNT.getPropertyName(), transformationRetries.toString());
                }
            }
            catch (ExtendedException e1) {
                // empty catch block
            }
            try {
                FencedOITransformationManager.init(workingProps);
                FencedOITransformationManager.getInstance();
            }
            catch (RemoteProcessException e) {
                Message msg = new Message("P2601E.START_TRANSFORMATION_SERVICE_ERROR");
                throw new TransformationException(msg, (Throwable)e);
            }
        }
    }

    public static void terminate() throws TransformationException {
        if (useStellent) {
            try {
                FencedOITransformationManager.term();
            }
            catch (RemoteProcessException e) {
                Message msg = new Message("P2602E.STOP_TRANSFORMATION_SERVICE_ERROR");
                throw new TransformationException(msg, (Throwable)e);
            }
        }
    }

    private static void prepareStellent(GlobalConfiguration config, String path) {
        String dataAccessModuleWindows = "sccda.dll";
        String dataAccessModuleLinux = "libsc_da.so";
        String dataAccessModuleAix = "libsc_da.o";
        String StellentZipFileWindows = "stellent_ts_v81_win32.zip";
        String StellentTgzFileLinux = "stellent_ts_v81_lnx32.zip";
        String StellentTgzFileAix = "stellent_ts_v81_aix32.zip";
        String stellentFilename = config.isWindows() ? path + File.separator + dataAccessModuleWindows : (config.isLinux() ? path + File.separator + dataAccessModuleLinux : path + File.separator + dataAccessModuleAix);
        File stellentExecutable = new File(stellentFilename);
        if (stellentExecutable.exists()) {
            return;
        }
        String stellentZipFilePath = config.isWindows() ? path + File.separator + StellentZipFileWindows : (config.isLinux() ? path + File.separator + StellentTgzFileLinux : path + File.separator + StellentTgzFileAix);
        File stellentZipFile = new File(stellentZipFilePath);
        if (!stellentZipFile.exists()) {
            return;
        }
        System.err.println("Unpacking Stellent");
        try {
            ZipFile zipFile = new ZipFile(stellentZipFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                InputStream is = zipFile.getInputStream(entry);
                byte[] buffer = new byte[4096];
                String fullPath = path + File.separator + entry.getName();
                new File(new File(fullPath).getParent()).mkdirs();
                FileOutputStream os = new FileOutputStream(fullPath);
                int bytesRead = 0;
                while ((bytesRead = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
                os.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!config.isWindows()) {
            try {
                String command = "chmod ugo+rx " + path + File.separator + "tsmanager";
                Runtime.getRuntime().exec(command);
                command = "chmod ugo+rx " + path + File.separator + "tsagent";
                Runtime.getRuntime().exec(command);
                command = "chmod ugo+rx " + path + File.separator + "ts_msg_logger_app";
                Runtime.getRuntime().exec(command);
                command = "chmod ugo+rx " + path + File.separator + "OutsideInProcess";
                Runtime.getRuntime().exec(command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.err.println("finished unpacking stellent");
    }

    private TransformationService() {
    }
}

