/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.text;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.parser.AbstractTextParser;
import com.ibm.es.nuvo.parser.MalformedEncodingException;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.ParserIOException;
import com.ibm.es.nuvo.parser.Segment;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.Properties;

public class TextParser
extends AbstractTextParser {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String CONTENT_TYPE = "text/plain";
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final String PARAM_BUFFER_SIZE = "parser.text.buffer.size";
    private char[] buffer;
    private byte[] byteBuffer;
    private Properties params;

    public void open(Properties p) {
        String bufsizeStr;
        super.open(p);
        this.params = p;
        int bufsize = 16384;
        if (this.params != null && (bufsizeStr = this.params.getProperty(PARAM_BUFFER_SIZE)) != null) {
            try {
                bufsize = Integer.parseInt(bufsizeStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        this.buffer = new char[bufsize];
        this.byteBuffer = new byte[bufsize];
    }

    public void parseText(String uri, Metadata metadata, InputStream input, ParserHandler handler, String detectedCharset) throws ParserException {
        String charset = null;
        String knownCharset = null;
        if (metadata != null) {
            metadata.set("doctype", CONTENT_TYPE);
            charset = metadata.get("Charset");
            knownCharset = metadata.get("KnownCharset");
        }
        handler.startDocument(uri, metadata);
        handler.addSegment(Segment.newSegment("doctype", CONTENT_TYPE, 327680));
        Reader reader = null;
        try {
            String encoding = charset;
            if (knownCharset != null) {
                reader = this.createReader(input, knownCharset);
                encoding = knownCharset;
            } else {
                InputStreamReader ar = this.createAutoDetectReader(input, encoding);
                if (ar != null) {
                    encoding = ar.getEncoding();
                }
                reader = ar;
            }
            if (encoding != null) {
                handler.addSegment(Segment.newSegment("charset", encoding, 327680));
                if (metadata != null) {
                    metadata.set("charset", encoding);
                }
            }
            if (reader != null) {
                int len = 0;
                while ((len = reader.read(this.buffer)) != -1) {
                    handler.addSegment(Segment.newSegment(null, this.buffer, 0, len, 0));
                }
            }
        }
        catch (CharConversionException e) {
            throw new MalformedEncodingException(uri, (Throwable)e);
        }
        catch (IOException e) {
            throw new ParserIOException(uri, (Throwable)e);
        }
        catch (ParserException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ParserException(uri, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
            handler.endDocument();
        }
    }

    private InputStreamReader createAutoDetectReader(InputStream input, String encoding) throws IOException {
        int len;
        PushbackInputStream pis = new PushbackInputStream(input, this.byteBuffer.length);
        int pos = 0;
        for (int remain = this.byteBuffer.length; remain > 0 && (len = pis.read(this.byteBuffer, pos, remain)) > 0; remain -= len) {
            pos += len;
        }
        if (pos > 0) {
            CharsetMatch[] matches;
            CharsetDetector detector = new CharsetDetector();
            detector.setText((InputStream)new ByteArrayInputStream(this.byteBuffer, 0, pos));
            if (encoding != null) {
                detector.setDeclaredEncoding(encoding);
            }
            if ((matches = detector.detectAll()) != null && matches.length > 0) {
                encoding = matches[0].getName();
            }
            pis.unread(this.byteBuffer, 0, pos);
        }
        if (encoding != null) {
            return this.createReader(pis, encoding);
        }
        return null;
    }

    public void close() throws ParserException {
    }
}

