/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.html;

import com.ibm.icu.text.CharsetMatch;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLCharsetDetector {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String IGNORE_SPECIFIED_CHARSET = "http://cyberneko.org/html/features/scanner/ignore-specified-charset";
    private static final String DEFAULT_ENCODING = "http://cyberneko.org/html/properties/default-encoding";
    private CharsetDetector detector = new CharsetDetector();
    private XMLReader parser;

    public String detect(byte[] content, int offset, int length) {
        ByteArrayInputStream in = new ByteArrayInputStream(content, offset, length);
        return this.detect(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String detect(InputStream in) {
        try {
            this.detector.reset();
            this.parser.setFeature(IGNORE_SPECIFIED_CHARSET, true);
            this.parser.setProperty(DEFAULT_ENCODING, "ISO-8859-1");
            this.parser.parse(new InputSource(in));
            String string = this.detector.detected();
            return string;
        }
        catch (IOException ignore) {
            String string = this.detector.detected();
            return string;
        }
        catch (SAXException ignore) {
            String string = this.detector.detected();
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
    }

    private static class CharsetDetector
    extends DefaultHandler {
        private static final byte HT = 9;
        private static final byte LF = 10;
        private static final byte CR = 13;
        private static final byte SP = 32;
        private static final int REQUIRED_AUTO_DETECT_SIZE = 0;
        private static final int MAX_SIZE_AUTO_DETECT_SIZE = 4096;
        private static final int DEFAULT_REQUIRED_CONFIDENCE_LEVEL = 20;
        private static final String META = "META";
        private static final String HTTP_EQUIV = "http-equiv";
        private static final String CONTENT_TYPE = "content-type";
        private static final String CONTENT = "content";
        private static final String CHARSET = "charset=";
        private boolean detected = false;
        private StringBuilder detectedCharset = new StringBuilder();
        private boolean ignore = false;
        private int pos = 0;
        private byte[] binary = new byte[4096];
        com.ibm.icu.text.CharsetDetector icuDetector = new com.ibm.icu.text.CharsetDetector();
        private int requireConfidence = 20;

        private CharsetDetector() {
        }

        private void reset() {
            this.detected = false;
            this.detectedCharset.setLength(0);
            this.ignore = false;
            this.pos = 0;
        }

        private String detected() {
            String charSet;
            if (this.detectedCharset.length() > 0 && Charset.isSupported(charSet = this.detectedCharset.toString())) {
                return charSet;
            }
            if (this.requireConfidence >= 0 && this.pos >= 0) {
                try {
                    this.icuDetector.setText((InputStream)new ByteArrayInputStream(this.binary, 0, this.pos));
                    CharsetMatch match = this.icuDetector.detect();
                    return match != null && match.getConfidence() >= this.requireConfidence ? match.getName() : null;
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }

        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            if (!this.detected) {
                if (localName != null && atts != null && localName.equalsIgnoreCase(META)) {
                    String httpequiv = atts.getValue(HTTP_EQUIV);
                    if (httpequiv != null && httpequiv.equalsIgnoreCase(CONTENT_TYPE)) {
                        int fromIdx;
                        String content = atts.getValue(CONTENT);
                        int n = fromIdx = content != null ? content.toLowerCase().indexOf(CHARSET) : -1;
                        if (fromIdx >= 0) {
                            int toIdx = content.indexOf(59, fromIdx);
                            String charset = toIdx != -1 ? content.substring(fromIdx, toIdx) : content.substring(fromIdx += 8);
                            this.detectedCharset.append(charset);
                            this.detected = true;
                            this.ignore = true;
                        }
                    }
                } else {
                    this.ignore = localName == null || localName.equalsIgnoreCase("script") || localName.equalsIgnoreCase("style");
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.ignore && length > 0) {
                int remain = this.binary.length - this.pos;
                int actual = remain > length ? length : remain;
                for (int i = 0; i < actual; ++i) {
                    byte b = (byte)ch[start + i];
                    if (b <= 32 && (b == 9 || b == 10 || b == 13 || b == 32)) continue;
                    this.binary[this.pos] = b;
                    ++this.pos;
                }
            }
        }
    }
}

