/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.html;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.ParserStage;
import com.ibm.es.nuvo.parser.Segment;
import java.net.URI;
import java.net.URISyntaxException;

public class AnchorCleanser
extends ParserStage {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private URI baseURI = null;

    public AnchorCleanser(ParserHandler handler) {
        super(handler);
    }

    private void setURI(String uri) {
        try {
            this.baseURI = new URI(uri);
        }
        catch (URISyntaxException e) {
            this.baseURI = null;
            return;
        }
        if (this.baseURI.isOpaque()) {
            this.baseURI = null;
            return;
        }
        if (!this.baseURI.isAbsolute()) {
            this.baseURI = null;
            return;
        }
        if (!("file".equals(this.baseURI.getScheme()) || "http".equals(this.baseURI.getScheme()) || "https".equals(this.baseURI.getScheme()))) {
            this.baseURI = null;
            return;
        }
    }

    private String resolveLink(String uriString) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            return null;
        }
        if (uri.isOpaque()) {
            return null;
        }
        if (uri.isAbsolute()) {
            if (!("file".equals(uri.getScheme()) || "http".equals(uri.getScheme()) || "https".equals(uri.getScheme()))) {
                return null;
            }
        } else {
            if (this.baseURI == null) {
                return null;
            }
            uri = this.baseURI.resolve(uri);
        }
        if (this.baseURI != null && uri.getScheme().equals(this.baseURI.getScheme()) && uri.getSchemeSpecificPart().equals(this.baseURI.getSchemeSpecificPart())) {
            return null;
        }
        String resultURI = uri.toString();
        String fragment = uri.getRawFragment();
        if (fragment != null && resultURI.endsWith(fragment)) {
            resultURI = resultURI.substring(0, resultURI.length() - fragment.length() - 1);
        }
        return resultURI;
    }

    public void startDocument(String u, Metadata meta) throws ParserException {
        this.setURI(u);
        super.startDocument(u, meta);
    }

    public void addSegment(Segment segment) throws ParserException {
        if ("base".equals(segment.getName())) {
            this.setURI(segment.getText());
            return;
        }
        if (segment.test(524288)) {
            String targetURL = this.resolveLink(segment.getText());
            if (targetURL != null) {
                super.addSegment(Segment.newSegment(segment.getName(), targetURL, segment.getFlags()));
            }
        } else {
            super.addSegment(segment);
        }
    }

    public static void main(String[] args) {
    }
}

