/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.config.xml;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationChangeNotification;
import com.ibm.es.nuvo.parser.config.ParserConfig;
import com.ibm.es.nuvo.parser.config.ParserServiceConfig;
import com.ibm.es.nuvo.parser.config.xml.SystemUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLParserServiceConfig
implements ParserServiceConfig {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Map<String, ParserConfig> parsers = new TreeMap<String, ParserConfig>();
    private String defaultParserName;
    private Properties prop = new Properties();
    private boolean isStoreTokenVectorsEnabled = true;
    private Map<String, String> fieldMappings = new TreeMap<String, String>();
    private CollectionConfiguration collectionConfig;

    XMLParserServiceConfig() {
    }

    @Override
    public Map<String, ParserConfig> getParserConfigurations() {
        return Collections.unmodifiableMap(this.parsers);
    }

    @Override
    public Properties getProperties() {
        return this.prop;
    }

    @Override
    public String getDefaultParserName() {
        return this.defaultParserName;
    }

    @Override
    public boolean isStoreTokenVectorsEnabled() {
        return this.isStoreTokenVectorsEnabled;
    }

    void addParserMappings(String parserName, List<String> mimeTypes) {
        ParserConfig config = this.parsers.get(parserName);
        for (String mimeType : mimeTypes) {
            config.addMimeType(mimeType);
        }
    }

    void setDefaultParserName(String defaultParserName) {
        this.defaultParserName = defaultParserName;
    }

    void setProperty(String key, String value) {
        this.prop.setProperty(key, value);
    }

    void addParserConfig(String name, ParserConfig config) {
        this.parsers.put(name, config);
    }

    void setStoreTokenVectorsEnabled(boolean enabled) {
        this.isStoreTokenVectorsEnabled = enabled;
    }

    @Override
    public String addFieldMapping(String srcName, String destName) {
        if (srcName == null) {
            return null;
        }
        String prev = this.fieldMappings.put(srcName = srcName.toLowerCase(), destName = destName == null ? srcName : destName.toLowerCase());
        if (prev == null || !prev.equals(destName)) {
            this.fireRebuildNeededNotification();
        }
        return prev;
    }

    @Override
    public Map<String, String> getFieldMappings() {
        return Collections.unmodifiableMap(this.fieldMappings);
    }

    @Override
    public String removeFieldMapping(String srcName) {
        if (srcName == null) {
            return null;
        }
        String prev = this.fieldMappings.remove(srcName.toLowerCase());
        if (prev != null) {
            this.fireRebuildNeededNotification();
        }
        return prev;
    }

    @Override
    public void setCollectionConfiguration(CollectionConfiguration config) {
        this.collectionConfig = config;
        for (ParserConfig pc : this.parsers.values()) {
            pc.setCollectionConfiguration(config);
        }
    }

    private void fireRebuildNeededNotification() {
        String cid;
        if (this.collectionConfig != null && !SystemUtil.isEmptyCollection(cid = this.collectionConfig.getId())) {
            ConfigurationChangeNotification.notifyCollectionRebuildNeeded(cid);
        }
    }
}

