/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.config.xml;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationChangeNotification;
import com.ibm.es.nuvo.parser.config.FieldMappingRule;
import com.ibm.es.nuvo.parser.config.ParserConfig;
import com.ibm.es.nuvo.parser.config.xml.SystemUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLParserConfig
implements ParserConfig {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String className;
    private Set<String> mimeTypes = new TreeSet<String>();
    private Properties prop = new Properties();
    private List<FieldMappingRule> mappingRules;
    private CollectionConfiguration collectionConfig;

    XMLParserConfig(String className) {
        this.className = className;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties() {
        Properties properties = this.prop;
        synchronized (properties) {
            return this.prop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMimeType(String mimeType) {
        Set<String> set = this.mimeTypes;
        synchronized (set) {
            this.mimeTypes.add(mimeType);
        }
        this.fireRebuildNeededNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getMimeTypes() {
        Set<String> set = this.mimeTypes;
        synchronized (set) {
            return Collections.unmodifiableSet(this.mimeTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putAll(Properties properties) {
        Properties properties2 = this.prop;
        synchronized (properties2) {
            this.prop.putAll((Map<?, ?>)properties);
        }
        this.fireRebuildNeededNotification();
    }

    @Override
    public synchronized List<FieldMappingRule> getFieldMappingRules() {
        return this.mappingRules != null ? Collections.unmodifiableList(this.mappingRules) : null;
    }

    @Override
    public synchronized void setFieldMappingRules(List<FieldMappingRule> rules) {
        if (rules != null) {
            ArrayList<FieldMappingRule> tmp = new ArrayList<FieldMappingRule>();
            tmp.addAll(rules);
            this.mappingRules = tmp;
        } else {
            this.mappingRules = null;
        }
        this.fireRebuildNeededNotification();
    }

    @Override
    public void setCollectionConfiguration(CollectionConfiguration config) {
        this.collectionConfig = config;
    }

    private void fireRebuildNeededNotification() {
        String cid;
        if (this.collectionConfig != null && !SystemUtil.isEmptyCollection(cid = this.collectionConfig.getId())) {
            ConfigurationChangeNotification.notifyCollectionRebuildNeeded(cid);
        }
    }
}

