/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.config.xml;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.parser.ParserConfigException;
import com.ibm.es.nuvo.parser.config.FieldMappingRule;
import com.ibm.es.nuvo.parser.config.ParserConfig;
import com.ibm.es.nuvo.parser.config.ParserServiceConfig;
import com.ibm.es.nuvo.parser.config.ParserServiceConfigPublisher;
import com.ibm.es.nuvo.parser.config.xml.Constants;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

public class XMLConfigPublisher
implements ParserServiceConfigPublisher,
Constants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public void publish(OutputStream os, ParserServiceConfig config) throws ExtendedException {
        byte[] data;
        XMLTagger tagger = new XMLTagger(true);
        tagger.writeText("<?xml version=\"1.0\" encoding=\"utf-8\"?>", false);
        this.publish(tagger, config);
        try {
            data = tagger.getXML().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            data = tagger.getXML().getBytes();
        }
        try {
            os.write(data);
        }
        catch (IOException e) {
            throw new ParserConfigException(e);
        }
    }

    public void publish(XMLTagger tagger, ParserServiceConfig config) throws ExtendedException {
        tagger.openStartElement("ParserService");
        tagger.writeAttr("Version", "1.00");
        tagger.writeAttr("xmlns", "http://www.ibm.com/es/nuvo/parser/configuration");
        tagger.closeTag();
        for (Map.Entry<String, ParserConfig> entry : config.getParserConfigurations().entrySet()) {
            ParserConfig parser = entry.getValue();
            tagger.startElement("Parser");
            tagger.startElement("ParserName");
            tagger.writeText(entry.getKey());
            tagger.endElement("ParserName");
            tagger.startElement("ParserClass");
            tagger.writeText(parser.getClassName());
            tagger.endElement("ParserClass");
            for (Object key : parser.getProperties().keySet()) {
                tagger.openStartElement("Parameter");
                tagger.writeAttr("Name", (String)key);
                tagger.closeTag();
                tagger.writeText(parser.getProperties().getProperty((String)key));
                tagger.endElement("Parameter");
            }
            tagger.endElement("Parser");
        }
        for (Map.Entry<String, ParserConfig> entry : config.getParserConfigurations().entrySet()) {
            tagger.openStartElement("ParserMapping");
            tagger.writeAttr("ParserName", entry.getKey());
            tagger.closeTag();
            for (String mime : entry.getValue().getMimeTypes()) {
                tagger.startElement("Mimetype");
                tagger.writeText(mime);
                tagger.endElement("Mimetype");
            }
            tagger.endElement("ParserMapping");
        }
        for (Map.Entry<String, ParserConfig> entry : config.getParserConfigurations().entrySet()) {
            List<FieldMappingRule> rules = entry.getValue().getFieldMappingRules();
            if (rules == null) continue;
            tagger.openStartElement("Rules");
            tagger.writeAttr("ParserName", entry.getKey());
            tagger.closeTag();
            for (FieldMappingRule rule : rules) {
                FieldMappingRule.AnchorAction aa;
                List<FieldMappingRule.AttributeAction> aas;
                List<FieldMappingRule.AttributeCondition> attrCond;
                tagger.startElement("Rule");
                tagger.startElement("Conditions");
                if (rule.getElementName() != null) {
                    tagger.openStartElement("Element");
                    tagger.writeAttr("Name", rule.getElementName());
                    tagger.closeEndElementTag();
                }
                if ((attrCond = rule.getAttributeConditions()) != null && attrCond.size() > 0) {
                    for (FieldMappingRule.AttributeCondition cond : attrCond) {
                        tagger.openStartElement("Attribute");
                        tagger.writeAttr("Name", cond.getName());
                        if (!cond.getRule().equals((Object)FieldMappingRule.MatchRule.EXIST)) {
                            tagger.writeAttr("IfValue", cond.getValue());
                            tagger.writeAttr("Match", cond.getRule().toString().toLowerCase());
                        }
                        tagger.closeEndElementTag();
                    }
                }
                tagger.endElement("Conditions");
                tagger.startElement("Actions");
                FieldMappingRule.ElementAction ea = rule.getElementAction();
                if (ea != null) {
                    tagger.openStartElement("ElementAction");
                    tagger.writeAttr("Type", ea.getType().toString().toLowerCase());
                    if (ea.isSpace()) {
                        tagger.writeAttr("IsSpace", String.valueOf(ea.isSpace()));
                    }
                    if (ea.isParagraphEnd()) {
                        tagger.writeAttr("IsParagraphEnd", String.valueOf(ea.isParagraphEnd()));
                    }
                    if (ea.isFieldEnd()) {
                        tagger.writeAttr("IsFieldEnd", String.valueOf(ea.isFieldEnd()));
                    }
                    if (ea.getType().equals((Object)FieldMappingRule.AbstractAction.Type.FIELD)) {
                        FieldMappingRule.FieldNameRule nameRule = ea.getFieldNameRule();
                        tagger.writeAttr("FieldName", nameRule.getValue());
                        tagger.writeAttr("FieldNameType", nameRule.getType().toString().toLowerCase());
                    }
                    tagger.closeEndElementTag();
                }
                if ((aas = rule.getAttributeActions()) != null) {
                    for (FieldMappingRule.AttributeAction aa2 : aas) {
                        tagger.openStartElement("AttributeAction");
                        FieldMappingRule.FieldNameRule nameRule = aa2.getFieldNameRule();
                        tagger.writeAttr("FieldName", nameRule.getValue());
                        tagger.writeAttr("FieldNameType", nameRule.getType().toString().toLowerCase());
                        tagger.writeAttr("ValueFrom", aa2.getAttributeNameForValue());
                        tagger.closeEndElementTag();
                    }
                }
                if ((aa = rule.getAnchorAction()) != null) {
                    tagger.openStartElement("AnchorAction");
                    tagger.writeAttr("TargetFrom", aa.getTargetAttributeName());
                    tagger.closeEndElementTag();
                }
                tagger.endElement("Actions");
                tagger.endElement("Rule");
            }
            tagger.endElement("Rules");
        }
        if (config.getDefaultParserName() != null) {
            tagger.startElement("DefaultParserMapping");
            tagger.startElement("ParserName");
            tagger.writeText(config.getDefaultParserName());
            tagger.endElement("ParserName");
            tagger.endElement("DefaultParserMapping");
        }
        tagger.openStartElement("StoreTokenVectors");
        tagger.writeAttr("Enabled", String.valueOf(config.isStoreTokenVectorsEnabled()));
        tagger.closeEndElementTag();
        for (Object object : config.getProperties().keySet()) {
            tagger.openStartElement("Parameter");
            tagger.writeAttr("Name", (String)object);
            tagger.closeTag();
            tagger.writeText(config.getProperties().getProperty((String)object));
            tagger.endElement("Parameter");
        }
        tagger.startElement("FieldMappings");
        for (Map.Entry entry : config.getFieldMappings().entrySet()) {
            tagger.openStartElement("FieldMapping");
            tagger.writeAttr("SrcName", (String)entry.getKey());
            tagger.writeAttr("DestName", (String)entry.getValue());
            tagger.closeEndElementTag();
        }
        tagger.endElement("FieldMappings");
        tagger.endElement("ParserService");
    }
}

