/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.config.xml;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.parser.ParserConfigException;
import com.ibm.es.nuvo.parser.config.FieldMappingRule;
import com.ibm.es.nuvo.parser.config.ParserConfig;
import com.ibm.es.nuvo.parser.config.ParserServiceConfig;
import com.ibm.es.nuvo.parser.config.ParserServiceConfigLoader;
import com.ibm.es.nuvo.parser.config.xml.Constants;
import com.ibm.es.nuvo.parser.config.xml.SystemUtil;
import com.ibm.es.nuvo.parser.config.xml.XMLParserConfig;
import com.ibm.es.nuvo.parser.config.xml.XMLParserServiceConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLConfigLoader
implements ParserServiceConfigLoader,
Constants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public ParserServiceConfig load(InputStream is) throws ExtendedException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ParserConfigReader reader = new ParserConfigReader();
            parser.parse(is, (DefaultHandler)reader);
            return reader.getConfig();
        }
        catch (ParserConfigurationException e) {
            throw new ParserConfigException(e);
        }
        catch (SAXException e) {
            throw new ParserConfigException(e);
        }
        catch (IOException e) {
            throw new ParserConfigException(e);
        }
    }

    private static class ParserConfigReader
    extends DefaultHandler {
        private static final int P = 1;
        private static final int PPR = 2;
        private static final int PP = 16;
        private static final int PPN = 256;
        private static final int PPC = 257;
        private static final int PPP = 258;
        private static final int PM = 32;
        private static final int PMMT = 513;
        private static final int PMPN = 514;
        private static final int DPM = 48;
        private static final int DPMPN = 769;
        private static final int R = 64;
        private static final int RR = 1024;
        private static final int RRC = 16384;
        private static final int RRCE = 262144;
        private static final int RRCA = 262145;
        private static final int RRA = 16385;
        private static final int RRAE = 262160;
        private static final int RRAA = 262161;
        private static final int RRAC = 262162;
        private static final int S = 3;
        private static final int M = 80;
        private static final int MM = 1280;
        private String pname;
        private StringBuilder value = new StringBuilder();
        private StringBuilder parserName = new StringBuilder();
        private StringBuilder parserClass = new StringBuilder();
        private StringBuilder mimetype = new StringBuilder();
        private Properties params = new Properties();
        private List<String> mimetypes = new ArrayList<String>();
        private Map<String, List<String>> mimeMappings = new HashMap<String, List<String>>();
        private FieldMappingRule rule;
        private List<FieldMappingRule> rules;
        private Map<String, List<FieldMappingRule>> ruleMappings = new HashMap<String, List<FieldMappingRule>>();
        private int state = 1;
        private int section = 1;
        private XMLParserServiceConfig config = new XMLParserServiceConfig();
        private boolean seenRules;
        private boolean seenMapping;

        private ParserConfigReader() {
        }

        ParserServiceConfig getConfig() {
            return this.config;
        }

        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            String name = qname;
            if ("Parser".equals(name)) {
                this.section = 16;
                this.state = 16;
                this.params = new Properties();
                if (atts.getValue("ParserName") != null) {
                    this.parserName.setLength(0);
                    this.parserName.append(atts.getValue("ParserName"));
                }
            } else if ("Parameter".equals(name) && this.section == 1) {
                this.state = 2;
                this.pname = atts.getValue("Name");
                this.value.setLength(0);
            } else if ("ParserName".equals(name) && this.section == 16) {
                this.parserName.setLength(0);
                this.state = 256;
            } else if ("ParserClass".equals(name) && this.section == 16) {
                this.parserClass.setLength(0);
                this.state = 257;
            } else if ("Parameter".equals(name) && this.section == 16) {
                this.state = 258;
                this.pname = atts.getValue("Name");
                this.value.setLength(0);
            } else if ("ParserMapping".equals(name)) {
                this.section = 32;
                this.state = 32;
                this.mimetypes = new ArrayList<String>();
                if (atts.getValue("ParserName") != null) {
                    this.parserName.setLength(0);
                    this.parserName.append(atts.getValue("ParserName"));
                }
            } else if ("ParserName".equals(name) && this.section == 32) {
                this.parserName.setLength(0);
                this.state = 514;
            } else if ("Mimetype".equals(name) && this.section == 32) {
                this.mimetype.setLength(0);
                this.state = 513;
            } else if ("DefaultParserMapping".equals(name)) {
                this.section = 48;
                this.state = 48;
            } else if ("ParserName".equals(name) && this.section == 48) {
                this.parserName.setLength(0);
                this.state = 769;
            } else if ("Rules".equals(name)) {
                this.section = 64;
                this.parserName.setLength(0);
                this.parserName.append(atts.getValue("ParserName"));
                this.rules = new ArrayList<FieldMappingRule>();
                this.seenRules = true;
            } else if ("Rule".equals(name) && this.section == 64) {
                this.section = 1024;
                this.rule = new FieldMappingRule();
            } else if ("Conditions".equals(name) && this.section == 1024) {
                this.section = 16384;
            } else if ("Element".equals(name) && this.section == 16384) {
                this.section = 262144;
                if (atts.getValue("Name") != null) {
                    this.rule.setElementName(atts.getValue("Name"));
                }
            } else if ("Attribute".equals(name) && this.section == 16384) {
                this.section = 262145;
                String attrName = atts.getValue("Name");
                if (attrName != null) {
                    String tmp = atts.getValue("IfValue");
                    if (tmp == null) {
                        this.rule.addAttributeCondition(new FieldMappingRule.AttributeCondition(attrName, FieldMappingRule.MatchRule.EXIST));
                    } else {
                        String match = atts.getValue("Match");
                        FieldMappingRule.MatchRule matchrule = null;
                        try {
                            matchrule = FieldMappingRule.MatchRule.valueOf(match.toUpperCase());
                            this.rule.addAttributeCondition(new FieldMappingRule.AttributeCondition(attrName, matchrule, tmp));
                        }
                        catch (Throwable e) {}
                    }
                }
            } else if ("Actions".equals(name) && this.section == 1024) {
                this.section = 16385;
            } else if ("ElementAction".equals(name) && this.section == 16385) {
                this.section = 262160;
                String typeStr = atts.getValue("Type");
                if (typeStr != null) {
                    FieldMappingRule.AbstractAction.Type type = null;
                    try {
                        type = FieldMappingRule.AbstractAction.Type.valueOf(typeStr.toUpperCase());
                        switch (type) {
                            case IGNORE: {
                                this.rule.setElementAction(new FieldMappingRule.IgnoreElementAction());
                                break;
                            }
                            case INLINE: {
                                boolean isSpace = "true".equalsIgnoreCase(atts.getValue("IsSpace"));
                                this.rule.setElementAction(new FieldMappingRule.InlineElementAction(isSpace));
                                break;
                            }
                            case FIELD: {
                                boolean isParagraphEnd = "true".equalsIgnoreCase(atts.getValue("IsParagraphEnd"));
                                boolean isFieldEnd = "true".equalsIgnoreCase(atts.getValue("IsFieldEnd"));
                                String fieldName = atts.getValue("FieldName");
                                String fieldNameTypeStr = atts.getValue("FieldNameType");
                                if (fieldNameTypeStr == null) break;
                                FieldMappingRule.FieldNameRule.Type nameType = null;
                                try {
                                    nameType = FieldMappingRule.FieldNameRule.Type.valueOf(fieldNameTypeStr.toUpperCase());
                                    FieldMappingRule.FieldNameRule nameRule = nameType.equals((Object)FieldMappingRule.FieldNameRule.Type.PLAIN) ? new FieldMappingRule.FieldNameRule(nameType) : new FieldMappingRule.FieldNameRule(nameType, fieldName);
                                    this.rule.setElementAction(new FieldMappingRule.FieldElementAction(nameRule, isParagraphEnd, isFieldEnd));
                                    break;
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    catch (Throwable e) {}
                }
            } else if ("AttributeAction".equals(name) && this.section == 16385) {
                this.section = 262161;
                String fieldName = atts.getValue("FieldName");
                String fieldNameTypeStr = atts.getValue("FieldNameType");
                String valueAttrName = atts.getValue("ValueFrom");
                if (fieldName != null && fieldNameTypeStr != null && valueAttrName != null) {
                    FieldMappingRule.FieldNameRule.Type nameType = null;
                    try {
                        nameType = FieldMappingRule.FieldNameRule.Type.valueOf(fieldNameTypeStr.toUpperCase());
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (nameType != null) {
                        this.rule.addAttributeAction(new FieldMappingRule.AttributeAction(new FieldMappingRule.FieldNameRule(nameType, fieldName), valueAttrName));
                    }
                }
            } else if ("AnchorAction".equals(name) && this.section == 16385) {
                this.section = 262162;
                String targetFrom = atts.getValue("TargetFrom");
                if (targetFrom != null) {
                    this.rule.setAnchorAction(new FieldMappingRule.AnchorAction(targetFrom));
                }
            } else if ("StoreTokenVectors".equals(name) && this.section == 1) {
                this.section = 3;
                String enabled = atts.getValue("Enabled");
                if (enabled != null) {
                    try {
                        this.config.setStoreTokenVectorsEnabled(Boolean.parseBoolean(enabled));
                    }
                    catch (Throwable e) {}
                }
            } else if ("FieldMappings".equals(name) && this.section == 1) {
                this.section = 80;
                this.seenMapping = true;
            } else if ("FieldMapping".equals(name) && this.section == 80) {
                this.section = 1280;
                String src = atts.getValue("SrcName");
                String dest = atts.getValue("DestName");
                if (src != null && dest != null) {
                    this.config.addFieldMapping(src.toLowerCase(), dest.toLowerCase());
                }
            }
        }

        public void endElement(String uri, String localName, String qname) throws SAXException {
            String name = qname;
            if ("Parser".equals(name)) {
                this.state = 1;
                this.section = 1;
                if (this.parserName.length() > 0 && this.parserClass.length() > 0) {
                    XMLParserConfig xmlconfig = new XMLParserConfig(this.parserClass.toString());
                    xmlconfig.putAll(this.params);
                    this.config.addParserConfig(this.parserName.toString(), xmlconfig);
                }
            } else if ("Parameter".equals(name) && this.section == 1) {
                this.state = 1;
                if (this.pname != null && this.pname.length() > 0) {
                    this.config.setProperty(this.pname, this.value.toString());
                }
            } else if ("ParserName".equals(name) && this.section == 16) {
                this.state = 16;
            } else if ("ParserClass".equals(name) && this.section == 16) {
                this.state = 16;
            } else if ("Parameter".equals(name) && this.section == 16) {
                this.state = 16;
                if (this.pname != null && this.pname.length() > 0) {
                    this.params.setProperty(this.pname, this.value.toString());
                }
            } else if ("ParserMapping".equals(name)) {
                this.state = 1;
                this.section = 1;
                if (this.parserName.length() > 0 && !this.mimetypes.isEmpty()) {
                    String pn = this.parserName.toString();
                    this.mimeMappings.put(pn, this.mimetypes);
                }
            } else if ("ParserName".equals(name) && this.section == 32) {
                this.state = 32;
            } else if ("Mimetype".equals(name) && this.section == 32) {
                if (this.mimetype.length() > 0) {
                    this.mimetypes.add(this.mimetype.toString());
                }
                this.state = 32;
            } else if ("DefaultParserMapping".equals(name)) {
                this.state = 1;
                this.section = 1;
            } else if ("ParserName".equals(name) && this.section == 48) {
                if (this.parserName.length() > 0) {
                    this.config.setDefaultParserName(this.parserName.toString());
                }
                this.state = 48;
            } else if ("Rules".equals(name) && this.section == 64) {
                this.section = 1;
                this.ruleMappings.put(this.parserName.toString(), this.rules);
            } else if ("Rule".equals(name) && this.section == 1024) {
                this.section = 64;
                this.rules.add(this.rule);
            } else if ("Conditions".equals(name) && this.section == 16384) {
                this.section = 1024;
            } else if ("Element".equals(name) && this.section == 262144) {
                this.section = 16384;
            } else if ("Attribute".equals(name) && this.section == 262145) {
                this.section = 16384;
            } else if ("Actions".equals(name) && this.section == 16385) {
                this.section = 1024;
            } else if ("ElementAction".equals(name) && this.section == 262160) {
                this.section = 16385;
            } else if ("AttributeAction".equals(name) && this.section == 262161) {
                this.section = 16385;
            } else if ("AnchorAction".equals(name) && this.section == 262162) {
                this.section = 16385;
            } else if ("StoreTokenVectors".equals(name) && this.section == 3) {
                this.section = 1;
            } else if ("FieldMappings".equals(name) && this.section == 80) {
                this.section = 1;
            } else if ("FieldMapping".equals(name) && this.section == 1280) {
                this.section = 80;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.state) {
                case 256: 
                case 514: 
                case 769: {
                    this.parserName.append(ch, start, length);
                    break;
                }
                case 257: {
                    this.parserClass.append(ch, start, length);
                    break;
                }
                case 2: 
                case 258: {
                    this.value.append(ch, start, length);
                    break;
                }
                case 513: {
                    this.mimetype.append(ch, start, length);
                    break;
                }
            }
        }

        public void endDocument() throws SAXException {
            for (Map.Entry<String, List<String>> entry : this.mimeMappings.entrySet()) {
                this.config.addParserMappings(entry.getKey(), entry.getValue());
            }
            Map<String, ParserConfig> parsers = this.config.getParserConfigurations();
            for (Map.Entry<String, ParserConfig> entry : parsers.entrySet()) {
                List<FieldMappingRule> mappingRules = this.ruleMappings.get(entry.getKey());
                if (entry.getValue() == null) continue;
                if (mappingRules != null) {
                    entry.getValue().setFieldMappingRules(mappingRules);
                    continue;
                }
                if (this.seenRules) continue;
                ParserConfig defaultConfig = SystemUtil.defaultParserServiceConfig().getParserConfigurations().get(entry.getKey());
                entry.getValue().setFieldMappingRules(defaultConfig.getFieldMappingRules());
            }
            if (!this.seenMapping) {
                for (Map.Entry<String, Object> entry : SystemUtil.defaultParserServiceConfig().getFieldMappings().entrySet()) {
                    this.config.addFieldMapping(entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }
}

