/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.config.xml;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.indexer.IndexerMonitor;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.parser.config.ParserServiceConfig;
import java.util.logging.Level;

public class SystemUtil {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    static boolean isEmptyCollection(String collectionId) {
        GlobalSystem gs = GlobalSystem.getSingleInstance();
        DocumentQueueInterface dq = gs.getDocumentQueue();
        IndexerMonitor im = gs.getIndexerMonitor();
        boolean indexEmpty = im != null && im.getNumberOfDocuments(collectionId) == 0L;
        boolean haveQueueWithNoDocsProcessed = dq != null && dq.getCounter() == 0;
        return indexEmpty && haveQueueWithNoDocsProcessed;
    }

    static ParserServiceConfig defaultParserServiceConfig() {
        try {
            return CollectionConfiguration.createDefault().getParserServiceConfig();
        }
        catch (ExtendedException e) {
            if (Loggers.logger.isLoggable(Level.SEVERE)) {
                Loggers.logger.log(Level.SEVERE, e);
            }
            return null;
        }
    }
}

