/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.config.xml;

import com.ibm.es.nuvo.parser.config.FieldMappingRule;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFieldMapperConfig {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String CONTENT_TYPE = "contenttype";

    static List<FieldMappingRule> createDefaultRule(String type) {
        if ("html".equals(type)) {
            return DefaultFieldMapperConfig.createDefaultHtmlMappingRule();
        }
        if ("stellent".equals(type)) {
            return DefaultFieldMapperConfig.createDefaultSearchMLMappingRule();
        }
        return null;
    }

    private static FieldMappingRule createInlineRule(String element, boolean addSpace) {
        FieldMappingRule rule = new FieldMappingRule();
        rule.setElementName(element);
        rule.setElementAction(new FieldMappingRule.InlineElementAction(addSpace));
        return rule;
    }

    private static FieldMappingRule createParagraphRule(String element, String target, boolean fieldend) {
        FieldMappingRule rule = new FieldMappingRule();
        rule.setElementName(element);
        if (target != null) {
            rule.setElementAction(new FieldMappingRule.FieldElementAction(new FieldMappingRule.FieldNameRule(FieldMappingRule.FieldNameRule.Type.FIXED, target), true, fieldend));
        } else {
            rule.setElementAction(new FieldMappingRule.FieldElementAction(new FieldMappingRule.FieldNameRule(FieldMappingRule.FieldNameRule.Type.PLAIN), true, fieldend));
        }
        return rule;
    }

    private static List<FieldMappingRule> createDefaultHtmlMappingRule() {
        ArrayList<FieldMappingRule> list = new ArrayList<FieldMappingRule>();
        FieldMappingRule rule = new FieldMappingRule();
        rule.setElementName("a");
        rule.addAttributeCondition(new FieldMappingRule.AttributeCondition("href", FieldMappingRule.MatchRule.EXIST));
        rule.setElementAction(new FieldMappingRule.InlineElementAction(true));
        rule.setAnchorAction(new FieldMappingRule.AnchorAction("href"));
        list.add(rule);
        list.add(DefaultFieldMapperConfig.createInlineRule("a", true));
        list.add(DefaultFieldMapperConfig.createInlineRule("abbr", true));
        list.add(DefaultFieldMapperConfig.createInlineRule("acronym", true));
        list.add(DefaultFieldMapperConfig.createInlineRule("b", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("br", true));
        list.add(DefaultFieldMapperConfig.createInlineRule("big", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("cite", true));
        list.add(DefaultFieldMapperConfig.createInlineRule("code", true));
        list.add(DefaultFieldMapperConfig.createInlineRule("dfn", true));
        list.add(DefaultFieldMapperConfig.createInlineRule("em", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("font", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("i", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("nobr", true));
        list.add(DefaultFieldMapperConfig.createInlineRule("q", true));
        list.add(DefaultFieldMapperConfig.createInlineRule("s", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("small", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("strike", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("strong", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("sub", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("super", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("tt", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("u", false));
        list.add(DefaultFieldMapperConfig.createInlineRule("var", true));
        list.add(DefaultFieldMapperConfig.createParagraphRule("title", "title", true));
        list.add(DefaultFieldMapperConfig.createParagraphRule("h1", "head", true));
        list.add(DefaultFieldMapperConfig.createParagraphRule("html", null, false));
        list.add(DefaultFieldMapperConfig.createParagraphRule("body", null, false));
        list.add(DefaultFieldMapperConfig.createParagraphRule("hr", null, false));
        rule = new FieldMappingRule();
        rule.addAttributeCondition(new FieldMappingRule.AttributeCondition("class", FieldMappingRule.MatchRule.EXACT, "access"));
        rule.setElementAction(new FieldMappingRule.IgnoreElementAction());
        list.add(rule);
        rule = new FieldMappingRule();
        rule.setElementName("script");
        rule.setElementAction(new FieldMappingRule.IgnoreElementAction());
        list.add(rule);
        rule = new FieldMappingRule();
        rule.setElementName("noscript");
        rule.setElementAction(new FieldMappingRule.IgnoreElementAction());
        list.add(rule);
        rule = new FieldMappingRule();
        rule.setElementName("style");
        rule.setElementAction(new FieldMappingRule.IgnoreElementAction());
        list.add(rule);
        rule = new FieldMappingRule();
        rule.setElementName("meta");
        rule.addAttributeCondition(new FieldMappingRule.AttributeCondition("http-equiv", FieldMappingRule.MatchRule.EXACT, "content-type"));
        rule.addAttributeAction(new FieldMappingRule.AttributeAction(new FieldMappingRule.FieldNameRule(FieldMappingRule.FieldNameRule.Type.FIXED, CONTENT_TYPE), "content"));
        list.add(rule);
        rule = new FieldMappingRule();
        rule.setElementName("meta");
        rule.addAttributeAction(new FieldMappingRule.AttributeAction(new FieldMappingRule.FieldNameRule(FieldMappingRule.FieldNameRule.Type.ATTRIBUTE, "name"), "content"));
        list.add(rule);
        rule = new FieldMappingRule();
        rule.setElementName("base");
        rule.addAttributeAction(new FieldMappingRule.AttributeAction(new FieldMappingRule.FieldNameRule(FieldMappingRule.FieldNameRule.Type.FIXED, "base"), "href"));
        list.add(rule);
        return list;
    }

    private static List<FieldMappingRule> createDefaultSearchMLMappingRule() {
        ArrayList<FieldMappingRule> list = new ArrayList<FieldMappingRule>();
        FieldMappingRule rule = new FieldMappingRule();
        rule.setElementName("doc_content");
        rule.setElementAction(new FieldMappingRule.FieldElementAction(new FieldMappingRule.FieldNameRule(FieldMappingRule.FieldNameRule.Type.PLAIN), true, false));
        list.add(rule);
        rule = new FieldMappingRule();
        rule.setElementName("doc_property");
        rule.addAttributeCondition(new FieldMappingRule.AttributeCondition("type", FieldMappingRule.MatchRule.EXACT, "title"));
        rule.setElementAction(new FieldMappingRule.FieldElementAction(new FieldMappingRule.FieldNameRule(FieldMappingRule.FieldNameRule.Type.FIXED, "title"), true, true));
        list.add(rule);
        rule = new FieldMappingRule();
        rule.setElementName("document");
        rule.addAttributeCondition(new FieldMappingRule.AttributeCondition("type", FieldMappingRule.MatchRule.EXIST));
        rule.addAttributeAction(new FieldMappingRule.AttributeAction(new FieldMappingRule.FieldNameRule(FieldMappingRule.FieldNameRule.Type.FIXED, CONTENT_TYPE), "type"));
        list.add(rule);
        rule = new FieldMappingRule();
        rule.setElementName("doc_property");
        rule.addAttributeCondition(new FieldMappingRule.AttributeCondition("type", FieldMappingRule.MatchRule.EXIST));
        rule.setElementAction(new FieldMappingRule.FieldElementAction(new FieldMappingRule.FieldNameRule(FieldMappingRule.FieldNameRule.Type.ATTRIBUTE, "type"), true, true));
        list.add(rule);
        rule = new FieldMappingRule();
        rule.setElementName("p");
        rule.setElementAction(new FieldMappingRule.FieldElementAction(new FieldMappingRule.FieldNameRule(FieldMappingRule.FieldNameRule.Type.PLAIN), true, false));
        list.add(rule);
        list.add(DefaultFieldMapperConfig.createInlineRule("r", true));
        return list;
    }
}

