/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMappingRule {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String elementName;
    private List<AttributeCondition> attributeConditions;
    private ElementAction elementAction;
    private List<AttributeAction> attributeActions;
    private AnchorAction anchorAction;

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String name) {
        this.elementName = name;
    }

    public List<AttributeCondition> getAttributeConditions() {
        return this.attributeConditions != null ? Collections.unmodifiableList(this.attributeConditions) : null;
    }

    public void addAttributeCondition(AttributeCondition cond) {
        if (this.attributeConditions == null) {
            this.attributeConditions = new ArrayList<AttributeCondition>();
        }
        for (AttributeCondition c : this.attributeConditions) {
            if (!c.getName().equals(cond.getName())) continue;
            this.attributeConditions.remove(c);
            this.attributeConditions.add(cond);
            return;
        }
        this.attributeConditions.add(cond);
    }

    public void removeAttributeCondition(String name) {
        if (this.attributeConditions != null) {
            for (AttributeCondition cond : this.attributeConditions) {
                if (!name.equals(cond.getName())) continue;
                this.attributeConditions.remove(cond);
                if (this.attributeConditions.size() != 0) break;
                this.attributeConditions = null;
                break;
            }
        }
    }

    public void setElementAction(ElementAction action) {
        this.elementAction = action;
    }

    public ElementAction getElementAction() {
        return this.elementAction;
    }

    public void addAttributeAction(AttributeAction action) {
        if (this.attributeActions == null) {
            this.attributeActions = new ArrayList<AttributeAction>();
        }
        for (AttributeAction a : this.attributeActions) {
            if (!a.getFieldNameRule().equals(action.getFieldNameRule())) continue;
            this.attributeActions.remove(a);
            this.attributeActions.add(action);
            return;
        }
        this.attributeActions.add(action);
    }

    public void removeAttributeAction(FieldNameRule rule) {
        if (this.attributeActions != null) {
            for (AttributeAction action : this.attributeActions) {
                if (!rule.equals(action.getFieldNameRule())) continue;
                this.attributeActions.remove(action);
                if (this.attributeActions.size() != 0) break;
                this.attributeActions = null;
                break;
            }
        }
    }

    public List<AttributeAction> getAttributeActions() {
        return this.attributeActions != null ? Collections.unmodifiableList(this.attributeActions) : null;
    }

    public void setAnchorAction(AnchorAction action) {
        this.anchorAction = action;
    }

    public AnchorAction getAnchorAction() {
        return this.anchorAction;
    }

    public String toString() {
        String ret;
        StringBuilder sb = new StringBuilder(64);
        if (this.elementName != null) {
            sb.append("Element=").append(this.elementName).append(",");
        }
        if (this.attributeConditions != null) {
            sb.append("AttributeConditions=").append(this.attributeConditions).append(", ");
        }
        if (this.elementAction != null) {
            sb.append("ElementAction=").append(this.elementAction).append(", ");
        }
        if (this.attributeActions != null) {
            sb.append("AttributeActions=").append(this.attributeActions).append(", ");
        }
        if (this.anchorAction != null) {
            sb.append("AnchorAction=").append(this.anchorAction).append(", ");
        }
        if ((ret = sb.toString()).length() >= 2) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    public static final class AnchorAction {
        private String targetAttribute;

        public AnchorAction(String targetAttribute) {
            this.targetAttribute = targetAttribute;
        }

        public String getTargetAttributeName() {
            return this.targetAttribute;
        }

        public String toString() {
            return "TargetAttribute=" + this.targetAttribute;
        }
    }

    public static final class AttributeAction
    extends AbstractAction {
        private String valueAttr;

        public AttributeAction(FieldNameRule rule, String valueAttr) {
            super(AbstractAction.Type.FIELD, rule);
            this.valueAttr = valueAttr;
        }

        public String getAttributeNameForValue() {
            return this.valueAttr;
        }

        public String toString() {
            return super.toString() + ", AttrNameForValue=" + this.valueAttr;
        }
    }

    public static final class FieldElementAction
    extends ElementAction {
        public FieldElementAction(FieldNameRule rule, boolean isParagraphEnd, boolean isFieldEnd) {
            super(AbstractAction.Type.FIELD, rule);
            this.setParagraphEnd(isParagraphEnd);
            this.setFieldEnd(isFieldEnd);
        }
    }

    public static final class InlineElementAction
    extends ElementAction {
        public InlineElementAction(boolean addSpace) {
            super(AbstractAction.Type.INLINE, null);
            this.setSpace(addSpace);
        }

        public InlineElementAction(boolean addSpace, boolean isParagraphEnd) {
            this(addSpace);
            this.setParagraphEnd(isParagraphEnd);
        }
    }

    public static final class IgnoreElementAction
    extends ElementAction {
        public IgnoreElementAction() {
            super(AbstractAction.Type.IGNORE, null);
        }
    }

    public static class ElementAction
    extends AbstractAction {
        private boolean isSpace;
        private boolean isParagraphEnd;
        private boolean isFieldEnd;

        protected ElementAction(AbstractAction.Type type, FieldNameRule rule) {
            super(type, rule);
        }

        protected void setSpace(boolean isSpace) {
            this.isSpace = isSpace;
        }

        protected void setParagraphEnd(boolean isParagraphEnd) {
            this.isParagraphEnd = isParagraphEnd;
        }

        protected void setFieldEnd(boolean isFieldEnd) {
            this.isFieldEnd = isFieldEnd;
        }

        public boolean isFieldEnd() {
            return this.isFieldEnd;
        }

        public boolean isParagraphEnd() {
            return this.isParagraphEnd;
        }

        public boolean isSpace() {
            return this.isSpace;
        }

        public String toString() {
            return super.toString() + ", IsSpace=" + this.isSpace + ", IsParagraphEnd=" + this.isParagraphEnd + ", IsFieldEnd=" + this.isFieldEnd;
        }
    }

    public static class AbstractAction {
        private Type type;
        private FieldNameRule rule;

        protected AbstractAction(Type type, FieldNameRule rule) {
            this.type = type;
            this.rule = rule;
        }

        public Type getType() {
            return this.type;
        }

        public FieldNameRule getFieldNameRule() {
            return this.rule;
        }

        public String toString() {
            return "Type=" + (Object)((Object)this.type) + (this.rule != null ? ", FieldNameRule=" + this.rule : "");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            IGNORE,
            INLINE,
            FIELD;

        }
    }

    public static final class FieldNameRule {
        private Type type;
        private String value;

        public FieldNameRule(Type type, String value) {
            if (type.equals((Object)Type.PLAIN)) {
                throw new IllegalArgumentException("Use the other ctor");
            }
            this.type = type;
            this.value = value;
        }

        public FieldNameRule(Type type) {
            if (!type.equals((Object)Type.PLAIN)) {
                throw new IllegalArgumentException("Use the other ctor");
            }
            this.type = type;
        }

        public final Type getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof FieldNameRule) {
                FieldNameRule other = (FieldNameRule)o;
                return this.type.equals((Object)other.type) && this.getValue().equals(other.getValue());
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode() + (this.value != null ? this.value.hashCode() : 0);
        }

        public String toString() {
            return "Type=" + (Object)((Object)this.type) + (this.value != null ? ", Value=" + this.value : "");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            PLAIN,
            FIXED,
            ATTRIBUTE;

        }
    }

    public static final class AttributeCondition {
        private String name;
        private MatchRule rule;
        private String value;

        public AttributeCondition(String name, MatchRule rule) {
            if (!rule.equals((Object)MatchRule.EXIST)) {
                throw new IllegalArgumentException("Use the other ctor");
            }
            this.name = name;
            this.rule = rule;
        }

        public AttributeCondition(String name, MatchRule rule, String value) {
            if (rule.equals((Object)MatchRule.EXIST)) {
                throw new IllegalArgumentException("Use the other ctor");
            }
            this.name = name;
            this.rule = rule;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public MatchRule getRule() {
            return this.rule;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "Name=" + this.name + ", MatchRule=" + (Object)((Object)this.rule) + (this.value != null ? ", Value=" + this.value : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchRule {
        EXIST,
        EXACT,
        PREFIX,
        SUFFIX,
        CONTAIN;

    }
}

