/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType1;
import java.io.IOException;
import java.nio.CharBuffer;

public final class XMLTextBuffers {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private Appendable[] buffers = new Appendable[]{null, null};
    private long numberOfCharsInNames;
    private long truncaterRemainingChars = Long.MAX_VALUE;

    public synchronized void appendToXMLBuffer(int which, String text) throws IOException {
        this.buffer(which).append(text);
    }

    public synchronized void appendToXMLBuffer(int which, char[] ca) throws IOException {
        this.buffer(which).append(CharBuffer.wrap(ca));
    }

    public synchronized void appendToXMLBuffer(int which, char[] ca, int start, int length) throws IOException {
        this.buffer(which).append(CharBuffer.wrap(ca), start, length);
    }

    public int lengthOfXMLBuffer(int which) {
        return this.buffers[which] == null ? 0 : ((CharSequence)((Object)this.buffers[which])).length();
    }

    public CharSequence getXMLBuffer(int which) {
        return (CharSequence)((Object)this.buffers[which]);
    }

    public void addToCharsUsedInNames(long additionalCount) {
        this.numberOfCharsInNames += additionalCount;
    }

    public long getNumberOfCharsUsed() {
        long count = 0L;
        count += (long)this.lengthOfXMLBuffer(0);
        count += (long)this.lengthOfXMLBuffer(1);
        return count += this.numberOfCharsInNames;
    }

    public long getTruncaterRemainingChars() {
        return this.truncaterRemainingChars;
    }

    public void setTruncaterRemainingChars(long newValue) {
        this.truncaterRemainingChars = newValue < 0L ? 0L : newValue;
    }

    private Appendable buffer(int which) {
        if (this.buffers[which] == null) {
            this.buffers[which] = new NormalizedStringBufferType1(1024);
        }
        return this.buffers[which];
    }

    public static interface BufferType {
        public static final int TEXT_BUFFER = 0;
        public static final int ATTRVALUE_BUFFER = 1;
    }
}

