/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.parser.XMLTextBuffers;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLTagInfo {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int depth;
    private int lastDescendant;
    private final int serialNumber;
    private String tagName;
    private int tagTextStartPos;
    private int tagTextLength;
    private LinkedList<Attribute> attributes;
    private XMLTextBuffers textBuffers;
    private boolean overLimit;
    private long numberOfCharsInNames;
    private boolean whitespaceSeparatorPrepended;

    public XMLTagInfo(int tagSerialNumber) {
        this.lastDescendant = this.serialNumber = tagSerialNumber;
    }

    public XMLTagInfo(XMLTextBuffers b) {
        this.textBuffers = b;
        this.serialNumber = 0;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getLastDescendant() {
        return this.lastDescendant;
    }

    public String getTagName() {
        return this.tagName;
    }

    public int getTagTextStartPos() {
        return this.tagTextStartPos;
    }

    public int getTagTextLength() {
        return this.tagTextLength;
    }

    public XMLTextBuffers getTextBuffers() {
        return this.textBuffers;
    }

    public boolean isOverLimit() {
        return this.overLimit;
    }

    public boolean isWhitespaceSeparatorPrepended() {
        return this.whitespaceSeparatorPrepended;
    }

    public void setDepth(int tagDepth) {
        this.depth = tagDepth;
    }

    public void setLastDescendant(int lastDesc) {
        this.lastDescendant = lastDesc;
    }

    public void setOverLimit(boolean yesno) {
        this.overLimit = yesno;
    }

    public void setTagName(String name) {
        this.tagName = name;
        this.numberOfCharsInNames += name != null ? (long)name.length() : 0L;
    }

    public void setTagTextStartPos(int startPos) {
        this.tagTextStartPos = startPos;
    }

    public void setTagTextEnd(int endPosition) {
        this.tagTextLength = endPosition - this.tagTextStartPos;
    }

    public void setTextBuffers(XMLTextBuffers xtb) {
        this.textBuffers = xtb;
    }

    public void setWhitespaceSeparatorPrepended(boolean yesno) {
        this.whitespaceSeparatorPrepended = yesno;
    }

    public long getNumberOfCharsInNames() {
        return this.numberOfCharsInNames;
    }

    public synchronized Attribute addAttribute() {
        Attribute a = new Attribute();
        if (this.attributes == null) {
            this.attributes = new LinkedList();
        }
        this.attributes.add(a);
        String name = a.getName();
        this.numberOfCharsInNames += name != null ? (long)name.length() : 0L;
        return a;
    }

    public synchronized Iterator<Attribute> getAttributes() {
        return this.attributes == null ? null : this.attributes.iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Tag(").append(this.serialNumber).append(",").append(this.lastDescendant).append(",").append(this.depth).append(",").append(this.tagName).append(",").append(this.tagTextStartPos).append(",").append(this.tagTextLength);
        Iterator<Attribute> it = this.getAttributes();
        while (it != null && it.hasNext()) {
            Attribute a = it.next();
            sb.append("Att(").append(a.getName()).append(",").append(a.getValueStartPos()).append(",").append(a.getValueLength()).append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public static class Attribute {
        private String attrName;
        private int valueStartPos;
        private int valueLength;
        private Long longValue;
        private Double doubleValue;

        public String getName() {
            return this.attrName;
        }

        public int getValueLength() {
            return this.valueLength;
        }

        public int getValueStartPos() {
            return this.valueStartPos;
        }

        public Long getLongValue() {
            return this.longValue;
        }

        public Double getDoubleValue() {
            return this.doubleValue;
        }

        public boolean hasNumericValue() {
            return this.longValue != null || this.doubleValue != null;
        }

        public void setName(String name) {
            this.attrName = name;
        }

        public void setValueLength(int len) {
            this.valueLength = len;
        }

        public void setValueStartPos(int pos) {
            this.valueStartPos = pos;
        }

        public void setValue(Long l) {
            this.longValue = l;
        }

        public void setValue(Double d) {
            this.doubleValue = d;
        }
    }
}

