/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.ParserStage;
import com.ibm.es.nuvo.parser.Segment;

public class TitleCleanser
extends ParserStage {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private boolean previosIsTitle;
    private boolean seenTitle;

    public TitleCleanser(ParserHandler handler) {
        super(handler);
    }

    public void startDocument(String u, Metadata meta) throws ParserException {
        this.previosIsTitle = false;
        this.seenTitle = false;
        super.startDocument(u, meta);
    }

    public void addSegment(Segment segment) throws ParserException {
        String field = segment.getName();
        if (field != null && field.equalsIgnoreCase("title")) {
            if (this.seenTitle) {
                return;
            }
            int len = segment.length();
            if (len > 0) {
                boolean valid = false;
                for (int i = 0; i < len; ++i) {
                    if (Character.isSpaceChar(segment.charAt(i))) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    return;
                }
                this.previosIsTitle = true;
            }
        } else if (!this.seenTitle) {
            this.seenTitle = this.previosIsTitle;
        }
        super.addSegment(segment);
    }

    public void endDocument() throws ParserException {
        this.previosIsTitle = false;
        this.seenTitle = false;
        super.endDocument();
    }
}

