/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.ParserStage;
import com.ibm.es.nuvo.parser.Segment;
import com.ibm.es.nuvo.util.decimal.Decimal;
import java.util.LinkedList;

public class SegmentSorter
extends ParserStage {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final Segment EOF = Segment.newSegment(null, "\n\n", 65536);
    private LinkedList<Segment> queue = new LinkedList();
    private StringBuilder buffer = new StringBuilder();

    protected SegmentSorter(ParserHandler handler) {
        super(handler);
    }

    public void startDocument(String u, Metadata meta) throws ParserException {
        super.startDocument(u, meta);
        this.queue.clear();
        this.buffer = new StringBuilder();
    }

    public void addSegment(Segment segment) throws ParserException {
        if (segment != null) {
            if (segment.getName() == null) {
                super.addSegment(segment);
            } else {
                int begin = this.buffer.length();
                String name = segment.getName();
                int length = segment.length();
                int flags = segment.getFlags();
                this.buffer.append(segment);
                Decimal numeric = segment.getNumericValue();
                this.queue.offer(Segment.newSegment(name, this.buffer, begin, length, numeric, flags));
            }
        }
    }

    public void endDocument() throws ParserException {
        super.addSegment(EOF);
        while (!this.queue.isEmpty()) {
            super.addSegment(this.queue.remove());
        }
        super.endDocument();
    }
}

