/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.normalizer.FieldNormalizer;
import com.ibm.es.nuvo.normalizer.NormalizedStringBuffer;
import com.ibm.es.nuvo.parser.Flags;
import com.ibm.es.nuvo.util.decimal.Decimal;
import java.io.IOException;
import java.io.Writer;

public abstract class Segment
implements CharSequence {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String field;
    private int flags;
    private Decimal numericValue;

    protected Segment(String fieldName, int flags) {
        this.field = FieldNormalizer.normalize(fieldName);
        this.flags = flags;
    }

    public final String getName() {
        return this.field;
    }

    public final void setName(String name) {
        this.field = name;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void setFlags(int flags) {
        this.flags = flags;
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer();
        this.appendTo(buffer);
        return buffer.toString();
    }

    public Decimal getNumericValue() {
        return this.numericValue;
    }

    public abstract void appendTo(Appendable var1) throws IOException;

    public void appendTo(StringBuffer buf) {
        buf.append(this);
    }

    public void appendTo(StringBuilder buf) {
        buf.append(this);
    }

    public void appendTo(NormalizedStringBuffer buf) {
        buf.append(this);
    }

    public abstract void writeTo(Writer var1) throws IOException;

    public abstract int offset();

    public abstract String getAnchor();

    public abstract void setAnchor(String var1);

    public final boolean compatible(Segment other) {
        return other != null && (this.field == null && other.field == null || this.field != null && this.field.equals(other.field)) && (this.flags & 0xFFFF) == (other.flags & 0xFFFF);
    }

    public final boolean test(int f) {
        return (this.flags & f) != 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getName());
        buffer.append(": [");
        buffer.append(Flags.toString(this.flags));
        buffer.append("] \"");
        buffer.append(this);
        buffer.append("\"");
        return buffer.toString();
    }

    public static final Segment newSegment(String name, int flags) {
        return new NullSegment(name, flags);
    }

    public static final Segment newSegment(String name, char[] text, int begin, int length, int flags) {
        return new CharArraySegment(name, text, begin, length, flags);
    }

    public static final Segment newSegment(String name, CharSequence text, int begin, int length, int flags) {
        return new CharSequenceSegment(name, text, begin, length, flags);
    }

    public static final Segment newSegment(String name, String text, int flags) {
        return Segment.newSegment(name, text, 0, text.length(), flags);
    }

    public static final Segment newSegment(String name, CharSequence text, Decimal numeric, int flags) {
        Segment segment = Segment.newSegment(name, text, 0, text.length(), flags);
        segment.numericValue = numeric;
        return segment;
    }

    public static final Segment newSegment(String name, CharSequence text, int begin, int length, Decimal numeric, int flags) {
        Segment segment = Segment.newSegment(name, text, begin, length, flags);
        segment.numericValue = numeric;
        return segment;
    }

    private static final class CharArraySegment
    extends Segment {
        private static final char[] NULL = new char[0];
        private final char[] text;
        private final int begin;
        private final int length;
        private String anchor;

        private CharArraySegment(String name, char[] text, int begin, int length, int flags) {
            super(name, flags);
            if (text == null) {
                this.text = NULL;
                this.begin = 0;
                this.length = 0;
            } else {
                this.text = text;
                this.begin = begin;
                this.length = length;
            }
        }

        public String getText() {
            if (this.text == null) {
                return "";
            }
            return new String(this.text, this.begin, this.length);
        }

        public void appendTo(Appendable buf) throws IOException {
            buf.append(this);
        }

        public void appendTo(StringBuffer buf) {
            if (this.text != null && this.length > 0) {
                buf.append(this.text, this.begin, this.length);
            }
        }

        public void appendTo(StringBuilder buf) {
            if (this.text != null && this.length > 0) {
                buf.append(this.text, this.begin, this.length);
            }
        }

        public void appendTo(NormalizedStringBuffer buf) {
            if (this.text != null && this.length > 0) {
                buf.append(this.text, this.begin, this.length);
            }
        }

        public void writeTo(Writer writer) throws IOException {
            if (this.text != null && this.length > 0) {
                writer.write(this.text, this.begin, this.length);
            }
        }

        public char charAt(int i) {
            return this.text[this.begin + i];
        }

        public CharSequence subSequence(int start, int end) {
            return new String(this.text, this.begin + start, end - start);
        }

        public int length() {
            return this.length;
        }

        public int offset() {
            return this.begin;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public void setAnchor(String anchor) {
            this.anchor = anchor;
        }
    }

    private static final class CharSequenceSegment
    extends Segment {
        private static final String NULL = "";
        private final CharSequence sequence;
        private final int begin;
        private final int length;
        private String anchor;

        private CharSequenceSegment(String name, CharSequence text, int begin, int length, int flags) {
            super(name, flags);
            if (text == null) {
                this.sequence = NULL;
                this.begin = 0;
                this.length = 0;
            } else {
                this.sequence = text;
                this.begin = begin;
                this.length = length;
            }
            this.anchor = null;
        }

        public void appendTo(Appendable buf) throws IOException {
            if (this.sequence != null && this.length > 0) {
                int last = this.begin + this.length;
                if (last > this.sequence.length()) {
                    throw new IndexOutOfBoundsException();
                }
                buf.append(this.sequence, this.begin, last);
            }
        }

        public void appendTo(StringBuffer buf) {
            if (this.sequence != null && this.length > 0) {
                int last = this.begin + this.length;
                if (last > this.sequence.length()) {
                    throw new IndexOutOfBoundsException();
                }
                buf.append(this.sequence, this.begin, last);
            }
        }

        public void appendTo(StringBuilder buf) {
            if (this.sequence != null && this.length > 0) {
                int last = this.begin + this.length;
                if (last > this.sequence.length()) {
                    throw new IndexOutOfBoundsException();
                }
                buf.append(this.sequence, this.begin, last);
            }
        }

        public void writeTo(Writer writer) throws IOException {
            if (this.sequence != null && this.length > 0) {
                int last = this.begin + this.length;
                if (last > this.sequence.length()) {
                    throw new IndexOutOfBoundsException();
                }
                for (int i = this.begin; i < last; ++i) {
                    writer.write(this.sequence.charAt(i));
                }
            }
        }

        public char charAt(int i) {
            return this.sequence.charAt(this.begin + i);
        }

        public CharSequence subSequence(int start, int end) {
            return this.sequence.subSequence(this.begin + start, this.begin + end);
        }

        public int length() {
            return this.length;
        }

        public int offset() {
            return this.begin;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public void setAnchor(String anchor) {
            this.anchor = anchor;
        }
    }

    private static final class NullSegment
    extends Segment {
        private NullSegment(String name, int flags) {
            super(name, flags);
        }

        public String getText() {
            return "";
        }

        public void appendTo(Appendable buf) {
        }

        public void writeTo(Writer writer) {
        }

        public char charAt(int i) {
            throw new IndexOutOfBoundsException();
        }

        public CharSequence subSequence(int start, int end) {
            return "";
        }

        public int length() {
            return 0;
        }

        public int offset() {
            return 0;
        }

        public String getAnchor() {
            return null;
        }

        public void setAnchor(String anchor) {
        }
    }
}

