/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserFieldMapper;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.SAXHandlerException;
import com.ibm.es.nuvo.parser.Segment;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String uri;
    private Metadata metadata;
    private ParserHandler handler;
    private static final State DEFAULT_STATE = new State(null, 65536);
    private State state;
    private Stack<State> stateStack = new Stack();
    private ParserFieldMapper mapper;

    public void setURL(String crawlURI, String tokenizableURL) {
        this.uri = crawlURI;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setParserHandler(ParserHandler handler) {
        this.handler = handler;
    }

    public SAXHandler(ParserFieldMapper mapper) {
        this.mapper = mapper;
    }

    public void startDocument() throws SAXException {
        this.state = DEFAULT_STATE;
        this.stateStack.clear();
        try {
            this.handler.startDocument(this.uri, this.metadata);
        }
        catch (ParserException e) {
            throw new SAXHandlerException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.handler.endDocument();
        }
        catch (ParserException e) {
            throw new SAXHandlerException(e);
        }
    }

    private void startParagraph(int flags) throws ParserException {
        if ((flags & 0x50000) != 0 && (this.state.flags & 0x100) == 0) {
            Segment segment = Segment.newSegment(this.state.field, this.state.flags | 0x10000);
            this.handler.addSegment(segment);
        }
    }

    private void endParagraph() throws ParserException {
        if ((this.state.flags & 0x50000) != 0 && (this.state.flags & 0x100) == 0) {
            Segment segment = Segment.newSegment(this.state.field, this.state.flags);
            this.handler.addSegment(segment);
        }
    }

    public void startElement(String uristring, String localName, String qname, Attributes atts) throws SAXException {
        this.stateStack.push(this.state);
        if ((this.state.flags & 0x100) != 0) {
            return;
        }
        try {
            boolean ruleApplied = false;
            ParserFieldMapper.Rule rule = this.mapper.match(qname, atts);
            if (rule != null) {
                List<ParserFieldMapper.FieldEntry> fields = rule.getFields(atts);
                if (fields != null) {
                    for (ParserFieldMapper.FieldEntry field : fields) {
                        int newFlags = field.getFlags() | 0x40000 | 0x10000;
                        this.startParagraph(newFlags);
                        this.handler.addSegment(Segment.newSegment(field.getName(), field.getValue(), newFlags));
                        this.startParagraph(newFlags);
                    }
                }
                switch (rule.getElementRuleType()) {
                    case IGNORE: {
                        this.startParagraph(rule.getFlags());
                        this.state = new State(null, rule.getFlags());
                        return;
                    }
                    case INLINE: {
                        int newFlags = this.state.flags & 0xFFFF | rule.getFlags() & 0xFFFF0000;
                        this.startParagraph(newFlags);
                        this.state = new State(this.state.field, newFlags);
                        ruleApplied = true;
                        break;
                    }
                    case FIELD: {
                        String fieldName = rule.getFieldNameForElement(atts);
                        if (fieldName == null) break;
                        this.startParagraph(rule.getFlags());
                        this.state = new State("_plain".equals(fieldName) ? null : fieldName, rule.getFlags());
                        ruleApplied = true;
                    }
                }
            }
            if (ruleApplied) {
                String targetURL = rule.getTargetURLForAnchor(atts);
                if (targetURL != null) {
                    this.state.flags |= 0x400;
                    Segment segment = Segment.newSegment(this.state.field, targetURL, this.state.flags & 0xFFFF | 0x80000);
                    this.handler.addSegment(segment);
                }
            } else {
                this.startParagraph(this.state.flags);
            }
        }
        catch (ParserException e) {
            throw new SAXHandlerException(e);
        }
    }

    public void endElement(String uristring, String localName, String qname) throws SAXException {
        try {
            this.endParagraph();
            boolean addSpace = (this.state.flags & 0x20000) != 0;
            this.state = this.stateStack.pop();
            if (addSpace && (this.state.flags & 0x100) == 0) {
                char[] oneSpace = new char[]{' '};
                Segment segment = Segment.newSegment(this.state.field, oneSpace, 0, 1, this.state.flags & 0xFFFF);
                this.handler.addSegment(segment);
            }
        }
        catch (ParserException e) {
            throw new SAXHandlerException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (length > 0 && (this.state.flags & 0x100) == 0) {
                Segment segment = Segment.newSegment(this.state.field, ch, start, length, this.state.flags & 0xFFFF);
                this.handler.addSegment(segment);
            }
        }
        catch (ParserException e) {
            throw new SAXHandlerException(e);
        }
    }

    static class State {
        public String field;
        public int flags;

        public State(String fieldName, int flags) {
            this.field = fieldName;
            this.flags = flags;
        }
    }
}

