/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.api.DocumentPipelineExtension;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.DocumentPipelineExtensionManager;
import com.ibm.es.nuvo.configuration.FieldDefinition;
import com.ibm.es.nuvo.configuration.FieldDefinitions;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.normalizer.MimetypeNormalizer;
import com.ibm.es.nuvo.parser.DocumentPipelineExtensionWrapper;
import com.ibm.es.nuvo.parser.EmptyParser;
import com.ibm.es.nuvo.parser.FileExtExtractor;
import com.ibm.es.nuvo.parser.LargeTextTruncater;
import com.ibm.es.nuvo.parser.MetadataExtractor;
import com.ibm.es.nuvo.parser.Parser;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.SafeParserHandler;
import com.ibm.es.nuvo.parser.SegmentMapper;
import com.ibm.es.nuvo.parser.SegmentSorter;
import com.ibm.es.nuvo.parser.TitleCleanser;
import com.ibm.es.nuvo.parser.config.FieldMappingRule;
import com.ibm.es.nuvo.parser.config.ParserConfig;
import com.ibm.es.nuvo.parser.config.ParserServiceConfig;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ParserRegistry {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String EMPTY_PARSER_ID = "_empty";
    private static final String XMLPARSER_CLASS = "com.ibm.es.nuvo.parser.xml.XMLParser";
    private static final ParserConfig EMPTY_PARSER_CONFIG = new ParserConfig(){

        @Override
        public void addMimeType(String mimeType) {
        }

        @Override
        public String getClassName() {
            return EmptyParser.class.getName();
        }

        @Override
        public List<FieldMappingRule> getFieldMappingRules() {
            return null;
        }

        @Override
        public Set<String> getMimeTypes() {
            return null;
        }

        @Override
        public Properties getProperties() {
            return null;
        }

        @Override
        public void setFieldMappingRules(List<FieldMappingRule> rules) {
        }

        @Override
        public void setCollectionConfiguration(CollectionConfiguration config) {
        }
    };
    private ParserServiceConfig config;
    private Map<String, ParserPool> parsers = new HashMap<String, ParserPool>();
    private Map<String, String> mimeMaps;
    private String defaultParser;
    private Map<Parser, String> borrowedParsers = new HashMap<Parser, String>();
    private String collectionID;
    private Map<String, String> nameMappings;
    private Set<String> essentialFields;

    public ParserRegistry(CollectionConfiguration config) {
        this(config.getId(), config.getParserServiceConfig(), config.getFieldDefinitions());
    }

    private ParserRegistry(String collectionId, ParserServiceConfig config, FieldDefinitions fieldDefs) {
        EnumSet<FieldDefinitions.FieldType> types;
        Map<String, FieldDefinition> fields;
        this.config = config;
        this.collectionID = collectionId;
        this.mimeMaps = new HashMap<String, String>();
        this.nameMappings = config.getFieldMappings();
        if (fieldDefs != null && (fields = fieldDefs.getFieldDefinitions(types = EnumSet.of(FieldDefinitions.FieldType.Hidden, FieldDefinitions.FieldType.BuiltIn, FieldDefinitions.FieldType.Predefined))) != null) {
            this.essentialFields = fields.keySet();
        }
        for (Map.Entry<String, ParserConfig> entry : this.config.getParserConfigurations().entrySet()) {
            Parser parser;
            String name = entry.getKey();
            ParserConfig cpc = entry.getValue();
            String clazz = cpc.getClassName();
            if (XMLPARSER_CLASS.equals(clazz)) {
                try {
                    ReleaseInfo info = ReleaseInfo.getReleaseInfo();
                    if (info == null) continue;
                    if (!info.getValueAsBoolean("System", "XMLSearchSupported", false)) {
                    }
                }
                catch (ExtendedException e) {}
                continue;
            }
            if ((parser = ParserRegistry.newParser(clazz)) == null) continue;
            try {
                ParserPool pool = new ParserPool(cpc);
                this.parsers.put(name, pool);
                for (String mime : cpc.getMimeTypes()) {
                    this.mimeMaps.put(mime, name);
                }
            }
            catch (ParserException e) {
                Loggers.logger.log(e);
            }
        }
        try {
            this.parsers.put(EMPTY_PARSER_ID, new ParserPool(EMPTY_PARSER_CONFIG));
        }
        catch (ParserException e) {
            Loggers.logger.log(e);
        }
        if (this.config.getDefaultParserName() != null) {
            this.defaultParser = this.config.getDefaultParserName();
        }
    }

    public Parser acquire(String filename, Metadata metadata, boolean contentExists) {
        String id = contentExists ? (metadata != null ? this.getParserId(filename, metadata.get("ContentType"), metadata.get("KnownContentType")) : this.getParserId(filename, null, null)) : EMPTY_PARSER_ID;
        if (id == null) {
            id = this.defaultParser;
        }
        if (id != null) {
            return this.acquireParser(id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Parser acquireParser(String id) {
        Parser parser;
        ParserPool pool = this.parsers.get(id);
        if (pool != null && (parser = pool.acquire()) != null) {
            Map<Parser, String> map = this.borrowedParsers;
            synchronized (map) {
                this.borrowedParsers.put(parser, id);
                return parser;
            }
        }
        return null;
    }

    private String getParserId(String filename, String mimetype, String knownMime) {
        String pid;
        int index;
        String ext;
        String mime;
        String usedMime = null;
        if (knownMime != null && knownMime.length() != 0) {
            usedMime = knownMime;
        }
        if ((usedMime == null || usedMime.length() == 0) && filename != null && (mime = MimetypeNormalizer.normalize(ext = (index = filename.lastIndexOf(46)) > 0 ? filename.substring(index).toLowerCase() : ".")) != null) {
            usedMime = mime;
        }
        if (!(usedMime != null && usedMime.length() != 0 || mimetype == null || (usedMime = MimetypeNormalizer.normalize(mimetype)) != null && usedMime.length() != 0)) {
            usedMime = mimetype;
        }
        if (usedMime != null && this.mimeMaps.containsKey(usedMime) && (pid = this.mimeMaps.get(usedMime)) != null && this.parsers.containsKey(pid)) {
            return pid;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Parser parser) {
        if (parser != null) {
            Map<Parser, String> map = this.borrowedParsers;
            synchronized (map) {
                String id = this.borrowedParsers.get(parser);
                if (id != null) {
                    this.parsers.get(id).release(parser);
                    this.borrowedParsers.remove(parser);
                }
            }
        }
    }

    public void dispose() {
        for (String key : this.parsers.keySet()) {
            ParserRegistry.closeParserForce(this.parsers.get(key));
        }
        this.parsers.clear();
        this.mimeMaps.clear();
    }

    private static final void closeParserForce(ParserPool pool) {
        if (pool != null) {
            pool.close();
        }
    }

    private static final Parser newParser(String parserClassName) {
        try {
            return (Parser)Class.forName(parserClassName).newInstance();
        }
        catch (IllegalAccessException ignore) {
        }
        catch (InstantiationException ignore) {
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public ParserHandler wrap(ParserHandler nextHandler) {
        ParserHandler handler = nextHandler;
        handler = new SegmentSorter(handler);
        handler = new LargeTextTruncater(handler, this.config.getProperties());
        DocumentPipelineExtension ext = DocumentPipelineExtensionManager.getInstance().getExtension(this.collectionID);
        if (ext != null) {
            handler = new DocumentPipelineExtensionWrapper(handler, this.acquireParser("xml"), ext);
        }
        handler = new TitleCleanser(handler);
        handler = new FileExtExtractor(handler);
        handler = new MetadataExtractor(handler);
        handler = new SegmentMapper(handler, this.nameMappings, this.essentialFields);
        handler = new SafeParserHandler(handler);
        return handler;
    }

    private static class ParserPool {
        private static final String PROP_MAX_POOL_SIZE = "pool.size";
        private static final String PROP_MAX_POOL_WAIT = "pool.wait";
        private static final int DEFAULT_POOL_SIZE = 5;
        private static final int DEFAULT_POOL_WAIT = 60000;
        private ParserConfig parserConfig;
        private List<Parser> pooledParsers;
        private int count;
        private int maxSize = 5;
        private int maxWait = 60000;

        ParserPool(ParserConfig config) throws ParserException {
            this.parserConfig = config;
            this.pooledParsers = new LinkedList<Parser>();
            this.pooledParsers.add(this.newInstance());
            try {
                this.maxSize = Integer.parseInt(config.getProperties().getProperty(PROP_MAX_POOL_SIZE));
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (this.maxSize < 1) {
                this.maxSize = 5;
            }
            try {
                this.maxWait = Integer.parseInt(config.getProperties().getProperty(PROP_MAX_POOL_WAIT));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.maxWait < 0) {
                this.maxWait = 60000;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Parser acquire() {
            List<Parser> list = this.pooledParsers;
            synchronized (list) {
                if (this.pooledParsers.size() == 0) {
                    if (this.count >= this.maxSize) {
                        long start = System.currentTimeMillis();
                        while (this.pooledParsers.size() == 0) {
                            try {
                                long interval = start + (long)this.maxWait - System.currentTimeMillis();
                                if (interval <= 0L) break;
                                this.pooledParsers.wait(interval);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                        }
                        if (this.pooledParsers.size() == 0) {
                            return null;
                        }
                        return this.pooledParsers.remove(0);
                    }
                    try {
                        return this.newInstance();
                    }
                    catch (ParserException e) {
                        Loggers.logger.log(e);
                    }
                } else {
                    return this.pooledParsers.remove(0);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release(Parser parser) {
            List<Parser> list = this.pooledParsers;
            synchronized (list) {
                this.pooledParsers.add(parser);
                this.pooledParsers.notify();
            }
        }

        void close() {
            for (Parser parser : this.pooledParsers) {
                try {
                    parser.close();
                }
                catch (ParserException parserException) {}
            }
        }

        private Parser newInstance() throws ParserException {
            Parser parser = ParserRegistry.newParser(this.parserConfig.getClassName());
            if (parser != null) {
                parser.open(this.parserConfig);
                ++this.count;
                return parser;
            }
            return parser;
        }
    }
}

