/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.parser.Flags;
import com.ibm.es.nuvo.parser.config.FieldMappingRule;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class ParserFieldMapper {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static Rule defaultRule = null;
    private static FieldMappingRule.ElementAction defaultElementAction = new FieldMappingRule.InlineElementAction(false, true);
    private List<Rule> rules = new ArrayList<Rule>();

    public Rule match(String element, Attributes atts) {
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule rule = this.rules.get(i);
            if (!rule.matches(element, atts)) continue;
            return rule;
        }
        return defaultRule;
    }

    public void addRule(FieldMappingRule rule) {
        this.rules.add(new Rule(rule));
    }

    private static String getFieldName(FieldMappingRule.AbstractAction action, Attributes atts) {
        switch (action.getFieldNameRule().getType()) {
            case PLAIN: {
                return "_plain";
            }
            case FIXED: {
                return action.getFieldNameRule().getValue();
            }
            case ATTRIBUTE: {
                return atts.getValue(action.getFieldNameRule().getValue());
            }
        }
        return null;
    }

    static {
        FieldMappingRule rule = new FieldMappingRule();
        rule.setElementAction(defaultElementAction);
        defaultRule = new Rule(rule);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Rule {
        private FieldMappingRule rule;
        private int flags = 0;
        private List<FieldEntry> fields;
        private ElementRuleType elementRuleType = ElementRuleType.IGNORE;
        private FieldMappingRule.ElementAction elementAction;

        private Rule(FieldMappingRule rule) {
            this.rule = rule;
            this.elementAction = rule.getElementAction();
            if (this.elementAction == null) {
                this.elementAction = defaultElementAction;
            }
            this.flags = 0;
            if (this.elementAction.isSpace()) {
                this.flags |= 0x20000;
            }
            if (this.elementAction.isParagraphEnd()) {
                this.flags |= 0x10000;
            }
            if (this.elementAction.isFieldEnd()) {
                this.flags |= 0x40000;
            }
            switch (this.elementAction.getType()) {
                case IGNORE: {
                    this.elementRuleType = ElementRuleType.IGNORE;
                    this.flags |= 0x100;
                    break;
                }
                case INLINE: {
                    this.elementRuleType = ElementRuleType.INLINE;
                    this.flags |= 0x200;
                    break;
                }
                case FIELD: {
                    this.elementRuleType = ElementRuleType.FIELD;
                }
            }
        }

        public int getFlags() {
            return this.flags;
        }

        public ElementRuleType getElementRuleType() {
            return this.elementRuleType;
        }

        public String getTargetURLForAnchor(Attributes atts) {
            FieldMappingRule.AnchorAction aa = this.rule.getAnchorAction();
            if (aa != null) {
                return atts.getValue(aa.getTargetAttributeName());
            }
            return null;
        }

        public boolean matches(String elementName, Attributes atts) {
            if (this.rule.getElementName() != null && !this.rule.getElementName().equalsIgnoreCase(elementName)) {
                return false;
            }
            if (this.rule.getAttributeConditions() != null) {
                for (FieldMappingRule.AttributeCondition entry : this.rule.getAttributeConditions()) {
                    String attributeValue = atts.getValue(entry.getName());
                    if (attributeValue == null) {
                        return false;
                    }
                    boolean matches = false;
                    switch (entry.getRule()) {
                        case EXIST: {
                            matches = true;
                            break;
                        }
                        case EXACT: {
                            matches = entry.getValue().equalsIgnoreCase(attributeValue);
                            break;
                        }
                        case PREFIX: {
                            matches = attributeValue.startsWith(entry.getValue());
                            break;
                        }
                        case SUFFIX: {
                            matches = attributeValue.endsWith(entry.getValue());
                            break;
                        }
                        default: {
                            boolean bl = matches = attributeValue.indexOf(entry.getValue()) >= 0;
                        }
                    }
                    if (matches) continue;
                    return false;
                }
            }
            return true;
        }

        public String getFieldNameForElement(Attributes atts) {
            return ParserFieldMapper.getFieldName(this.elementAction, atts);
        }

        public List<FieldEntry> getFields(Attributes atts) {
            List<FieldMappingRule.AttributeAction> aas = this.rule.getAttributeActions();
            if (aas != null && aas.size() > 0) {
                if (this.fields == null) {
                    this.fields = new ArrayList<FieldEntry>();
                } else {
                    this.fields.clear();
                }
                for (FieldMappingRule.AttributeAction aa : aas) {
                    String value;
                    String name = ParserFieldMapper.getFieldName(aa, atts);
                    if (name == null || (value = atts.getValue(aa.getAttributeNameForValue())) == null) continue;
                    this.fields.add(new FieldEntry(name, value, 0));
                }
                return this.fields.size() > 0 ? this.fields : null;
            }
            return null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(32);
            sb.append("Rule=").append(this.rule).append(", Flags=[").append(Flags.toString(this.flags)).append("]");
            if (this.fields != null) {
                sb.append(", Fields=").append(this.fields);
            }
            sb.append(", ElementRuleType=").append((Object)this.elementRuleType);
            sb.append(", ElementAction=").append(this.elementAction);
            return sb.toString();
        }
    }

    public static class FieldEntry {
        private String name;
        private String value;
        private int flags;

        FieldEntry(String name, String value, int flags) {
            this.name = name;
            this.value = value;
            this.flags = flags;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        int getFlags() {
            return this.flags;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.name);
            buffer.append(": [");
            buffer.append(Flags.toString(this.flags));
            buffer.append("] \"");
            buffer.append(this.value);
            buffer.append("\"");
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementRuleType {
        IGNORE,
        INLINE,
        FIELD;

    }
}

