/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.common.MetadataPart;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.ParserStage;
import com.ibm.es.nuvo.parser.Segment;
import java.util.Date;
import java.util.Map;

class MetadataExtractor
extends ParserStage {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Segment fallbackDate;

    MetadataExtractor(ParserHandler handler) {
        super(handler);
    }

    public void startDocument(String uri, Metadata metadata) throws ParserException {
        super.startDocument(uri, metadata);
        this.fallbackDate = null;
        if (metadata != null) {
            MetadataPart part = metadata.getMetadataPart(Metadata.Type.CrawlerMetadata);
            String url = part.get("URL");
            if (url == null || url.trim().length() == 0) {
                url = uri;
            }
            this.addSegment(Segment.newSegment("url", url, 327680));
            String date = part.get("Date");
            if (date != null) {
                try {
                    Date docdate = new Date(Long.parseLong(date));
                    if (docdate != null) {
                        this.fallbackDate = Segment.newSegment("docdate", Long.toString(docdate.getTime()), 327680);
                    }
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            this.addMetadataPart(metadata.getMetadataPart(Metadata.Type.CrawlerImplicit), Metadata.Type.CrawlerImplicit);
            this.addMetadataPart(metadata.getMetadataPart(Metadata.Type.CrawlerFields), Metadata.Type.CrawlerFields);
        }
    }

    public void addSegment(Segment segment) throws ParserException {
        super.addSegment(segment);
        String name = segment.getName();
        if ("docdate".equals(name)) {
            this.fallbackDate = null;
        }
    }

    public void endDocument() throws ParserException {
        if (this.fallbackDate != null) {
            super.addSegment(this.fallbackDate);
            this.fallbackDate = null;
        }
        super.endDocument();
    }

    private void addMetadataPart(MetadataPart metadata, Metadata.Type type) throws ParserException {
        int flags = 327680;
        if (Metadata.Type.CrawlerFields.equals((Object)type)) {
            flags |= 0x800;
        }
        for (Map.Entry<String, MetadataPart.Value> entry : metadata.keyValues()) {
            this.addSegment(Segment.newSegment(entry.getKey(), entry.getValue().toString(), entry.getValue().getNumericValue(), flags));
        }
    }
}

