/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.ParserStage;
import com.ibm.es.nuvo.parser.Segment;
import com.ibm.es.nuvo.parser.TextTruncatedException;
import com.ibm.es.nuvo.parser.XMLTagInfo;
import com.ibm.es.nuvo.parser.XMLTextBuffers;
import java.util.Properties;

public class LargeTextTruncater
extends ParserStage {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long DEFAULT_LIMIT = 0x100000L;
    private static final String PARAM_LIMIT = "max.text.size";
    private final long limit;
    private String uri;
    private long remain;
    private XMLTextBuffers xmlTextBuffers;

    public LargeTextTruncater(ParserHandler handler, Properties params) {
        super(handler);
        String limitStr;
        long l = 0x100000L;
        if (params != null && (limitStr = params.getProperty(PARAM_LIMIT)) != null) {
            try {
                l = Long.parseLong(limitStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        this.limit = l;
    }

    public void startDocument(String u, Metadata meta) throws ParserException {
        super.startDocument(u, meta);
        this.uri = u;
        this.remain = this.limit;
    }

    public void addSegment(Segment segment) throws ParserException {
        if (this.remain >= 0L && segment != null) {
            int l = segment.length();
            if (this.remain >= (long)l) {
                this.remain -= (long)l;
                super.addSegment(segment);
            } else {
                super.addSegment(Segment.newSegment(segment.getName(), segment, 0, (int)this.remain, segment.getFlags()));
                this.remain = -1L;
            }
        }
    }

    public void addXMLTagInfo(XMLTagInfo xti) throws ParserException {
        XMLTextBuffers xtb = xti.getTextBuffers();
        if (xtb != null) {
            if (xtb != this.xmlTextBuffers) {
                this.xmlTextBuffers = xtb;
            } else {
                super.addXMLTagInfo(xti);
            }
        } else {
            this.remain = this.limit - this.xmlTextBuffers.getNumberOfCharsUsed();
            if (this.remain < 0L) {
                this.remain = -1L;
            }
            this.xmlTextBuffers.setTruncaterRemainingChars(this.remain);
            super.addXMLTagInfo(xti);
        }
    }

    public void endDocument() throws ParserException {
        super.endDocument();
        if (this.remain < 0L) {
            throw new TextTruncatedException(this.uri);
        }
        this.uri = null;
        this.remain = this.limit;
    }
}

