/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.api.DocumentPipelineExtension;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.parser.Parser;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.ParserStage;
import com.ibm.es.nuvo.parser.Segment;
import com.ibm.es.nuvo.parser.XMLTagInfo;
import com.ibm.es.nuvo.parser.xml.XMLParser;
import java.io.StringReader;

public class DocumentPipelineExtensionWrapper
extends ParserStage {
    XMLParser xmlParser;
    String uri;
    Metadata metadata;
    String currentFieldName = null;
    StringBuilder currentFieldValue = new StringBuilder();
    StringBuilder plainTextValue = new StringBuilder();
    DocumentPipelineExtension extension;

    public DocumentPipelineExtensionWrapper(ParserHandler handler, Parser parser, DocumentPipelineExtension ext) {
        super(handler);
        this.xmlParser = (XMLParser)parser;
        this.extension = ext;
    }

    public void startDocument(String uriString, Metadata meta) throws ParserException {
        this.uri = uriString;
        this.metadata = meta;
    }

    public void endDocument() throws ParserException {
        this.flushCurrentField();
        String xmlText = this.extension.createXML(this.uri, this.metadata, this.plainTextValue.toString());
        this.metadata.add("_xmlext", xmlText);
        this.plainTextValue.setLength(0);
        this.xmlParser.parseText(this.uri, this.metadata, new StringReader(xmlText), this.handler);
    }

    public void addSegment(Segment segment) throws ParserException {
        String name = segment.getName();
        if (name == null) {
            if (this.currentFieldName != null) {
                this.flushCurrentField();
            }
            this.plainTextValue.append(segment.getText());
        } else {
            if (!name.equals(this.currentFieldName)) {
                this.flushCurrentField();
                this.startNewField(name);
            }
            this.currentFieldValue.append(segment.getText());
            if ((segment.getFlags() & 0x40000) != 0) {
                this.flushCurrentField();
            }
        }
    }

    public void addXMLTagInfo(XMLTagInfo xti) throws ParserException {
    }

    private void flushCurrentField() {
        if (this.currentFieldName != null && this.currentFieldValue.length() > 0) {
            this.metadata.add(this.currentFieldName, this.currentFieldValue.toString());
            this.currentFieldValue.setLength(0);
        }
        this.currentFieldName = null;
    }

    private void startNewField(String name) {
        this.currentFieldValue.setLength(0);
        this.currentFieldName = name;
    }
}

