/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.parser.AbstractParser;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.ParserIOException;
import com.ibm.es.nuvo.parser.UnsupportedFormatException;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Properties;

public abstract class AbstractTextParser
extends AbstractParser {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int DEFAULT_EXAMINE_SIZE = 4096;
    private static final int DEFAULT_REQUIRED_CONFIDENCE = 0;
    private static final String PARAM_EXAMINE_SIZE = "max.text.size.examine";
    private static final String PARAM_REQUIRED_CONFIDENCE = "required.text.confidence";
    private PlaybackInputStream.Buffer buf;
    private int requiredConfidence;
    private CharsetDetector detector;
    private int bufferSize;
    private CharsetDecoder utf8Decoder;

    public void open(Properties params) {
        this.detector = new CharsetDetector();
        this.requiredConfidence = AbstractTextParser.safeGetParameterAsInt(params, PARAM_REQUIRED_CONFIDENCE, 0);
        this.bufferSize = AbstractTextParser.safeGetParameterAsInt(params, PARAM_EXAMINE_SIZE, 4096);
        this.buf = new PlaybackInputStream.Buffer(this.bufferSize);
        this.utf8Decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(" ");
    }

    protected InputStreamReader createReader(InputStream is, String charset) throws UnsupportedEncodingException {
        if ("UTF-8".equalsIgnoreCase(charset)) {
            return new InputStreamReader(is, this.utf8Decoder);
        }
        if (charset != null) {
            return new InputStreamReader(is, charset);
        }
        return new InputStreamReader(is);
    }

    private static final int safeGetParameterAsInt(Properties params, String name, int defaultValue) {
        String v;
        int ret = defaultValue;
        if (params != null && (v = params.getProperty(name)) != null) {
            try {
                ret = Integer.parseInt(v);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return ret;
    }

    public final void doParse(String uri, Metadata metadata, InputStream input, ParserHandler handler) throws ParserException {
        if (this.requiredConfidence > 0) {
            try {
                PlaybackInputStream pis = new PlaybackInputStream(input, this.buf);
                String encoding = null;
                int len = pis.getBufferedSize();
                if (len >= this.bufferSize) {
                    this.detector.setText(pis.getBufferedData());
                    CharsetMatch match = this.detector.detect();
                    if (match != null && match.getConfidence() >= this.requiredConfidence) {
                        encoding = match.getName();
                    }
                    if (encoding == null) {
                        throw new UnsupportedFormatException(uri);
                    }
                }
                this.parseText(uri, metadata, pis, handler, encoding);
            }
            catch (IOException e) {
                throw new ParserIOException(uri, (Throwable)e);
            }
        } else {
            this.parseText(uri, metadata, input, handler, null);
        }
    }

    protected abstract void parseText(String var1, Metadata var2, InputStream var3, ParserHandler var4, String var5) throws ParserException;

    protected static class PlaybackInputStream
    extends FilterInputStream {
        private final byte[] buf;
        private final byte[] sb;
        private int pos;
        private int count;

        public PlaybackInputStream(InputStream in, Buffer buffer) throws IOException {
            super(in);
            if (buffer == null) {
                throw new NullPointerException();
            }
            this.buf = buffer.buffer;
            this.count = 0;
            int len = 0;
            for (int remain = this.buf.length; remain > 0 && (len = in.read(this.buf, this.count, remain)) > 0; remain -= len) {
                this.count += len;
            }
            this.pos = 0;
            this.sb = new byte[1];
        }

        public int getBufferedSize() {
            return this.count;
        }

        public InputStream getBufferedData() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }

        public int read() throws IOException {
            int len = this.read(this.sb, 0, 1);
            return len > 0 ? this.sb[0] & 0xFF : -1;
        }

        public int read(byte[] b) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.pos < this.count) {
                int actual;
                int n = actual = this.pos + len > this.count ? this.count - this.pos : len;
                if (actual > 0) {
                    System.arraycopy(this.buf, this.pos, b, off, actual);
                    this.pos += actual;
                    return actual;
                }
                return -1;
            }
            return super.read(b, off, len);
        }

        public int available() throws IOException {
            return this.pos < this.count ? this.count - this.pos : super.available();
        }

        public static final class Buffer {
            private byte[] buffer;

            public Buffer(int size) {
                this.buffer = new byte[size];
            }
        }
    }
}

