/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.parser;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.common.MetadataPart;
import com.ibm.es.nuvo.parser.Parser;
import com.ibm.es.nuvo.parser.ParserException;
import com.ibm.es.nuvo.parser.ParserFieldMapper;
import com.ibm.es.nuvo.parser.ParserHandler;
import com.ibm.es.nuvo.parser.SAXHandler;
import com.ibm.es.nuvo.parser.config.FieldMappingRule;
import com.ibm.es.nuvo.parser.config.ParserConfig;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParser
implements Parser {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private ParserFieldMapper mapper;

    protected abstract void open(Properties var1) throws ParserException;

    protected abstract void doParse(String var1, Metadata var2, InputStream var3, ParserHandler var4) throws ParserException;

    @Override
    public void open(ParserConfig config) throws ParserException {
        this.loadMapper(config.getFieldMappingRules());
        this.open(config.getProperties());
    }

    @Override
    public final void parse(String uri, Metadata metadata, InputStream input, ParserHandler handler) throws ParserException {
        if (metadata != null) {
            this.cleanse(metadata);
            metadata.fix();
        }
        this.doParse(uri, metadata, input, handler);
    }

    private void loadMapper(List<FieldMappingRule> rules) {
        if (rules != null && rules.size() > 0) {
            ParserFieldMapper newMapper = new ParserFieldMapper();
            for (FieldMappingRule rule : rules) {
                newMapper.addRule(rule);
            }
            this.mapper = newMapper;
        }
    }

    protected SAXHandler createSAXHandler() {
        return new SAXHandler(this.mapper);
    }

    private void cleanse(Metadata metadata) {
        String knownCharset;
        MetadataPart part = metadata.getMetadataPart(Metadata.Type.CrawlerMetadata);
        String charset = part.get("Charset");
        if (charset != null && !Charset.isSupported(charset)) {
            part.remove("Charset");
        }
        if ((knownCharset = part.get("KnownCharset")) != null && !Charset.isSupported(knownCharset)) {
            part.remove("KnownCharset");
        }
    }
}

