/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer.unicode;

import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.normalizer.Normalizer;
import com.ibm.es.nuvo.normalizer.NormalizerConfigurationException;
import com.ibm.es.nuvo.normalizer.unicode.CodePoint;
import com.ibm.es.nuvo.normalizer.unicode.CodePointSink;
import com.ibm.es.nuvo.normalizer.unicode.Form;
import com.ibm.es.nuvo.normalizer.unicode.IntBuffer;
import com.ibm.es.nuvo.normalizer.unicode.NormalizationData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public class UnicodeNormalizer
extends Normalizer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int DEFAULT_BUFFER_SIZE = 64;
    private static NormalizationData normData = new NormalizationData(0L);
    private static final char IN_BMP = '\uffff';
    private static final String NORM_DATA_FILE = "norm.dat";
    private static final String KEY_NORM_DATA_FILE = "whitney.normalizer.unicode";
    private CodePointSink buffer = new CodePointSink();
    private IntBuffer store = new IntBuffer();
    private char[] results = new char[64];
    private int curoff = 0;
    private boolean composite;
    private boolean canonical;
    private char lastChar = (char)65535;
    private short lastCC = (short)256;
    private final int minCP;

    UnicodeNormalizer(Form form) {
        this(form, null);
    }

    UnicodeNormalizer(Form form, Writer writer) {
        super(writer);
        switch (form) {
            case NFC: {
                this.canonical = true;
                this.composite = true;
                this.minCP = UnicodeNormalizer.normData.minCP4NFC;
                break;
            }
            case NFKC: {
                this.canonical = false;
                this.composite = true;
                this.minCP = UnicodeNormalizer.normData.minCP4NFKC;
                break;
            }
            case NFD: {
                this.canonical = true;
                this.composite = false;
                this.minCP = UnicodeNormalizer.normData.minCP4NFD;
                break;
            }
            case NFKD: {
                this.canonical = false;
                this.composite = false;
                this.minCP = UnicodeNormalizer.normData.minCP4NFKD;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void flush(boolean force) throws IOException {
        if (this.buffer.remain() > 0 || this.store.length() > 0) {
            this.normalizeBuffer(force);
        }
    }

    private void normalizeBuffer(boolean force) throws IOException {
        if (this.composite) {
            int cp;
            int starter;
            if (this.store.length() > 0) {
                starter = this.store.intAt(0);
            } else {
                this.lastCC = this.buffer.nextCC();
                starter = this.buffer.poll();
                this.store.append(starter);
            }
            short cc = this.buffer.nextCC();
            while ((cp = this.buffer.poll()) != -1) {
                int composition = normData.getComposition(starter, cp);
                if (composition != -1 && (this.lastCC < cc || this.lastCC == 0)) {
                    starter = composition;
                    this.store.setIntAt(0, starter);
                } else {
                    if (cc == 0) {
                        this.flushStoreToWriter(force);
                        starter = cp;
                    }
                    this.lastCC = cc;
                    this.store.append(cp);
                }
                cc = this.buffer.nextCC();
            }
            this.lastCC = cc;
        } else {
            int cp;
            while ((cp = this.buffer.poll()) != -1) {
                this.store.append(cp);
                if (this.buffer.nextCC() != 0) continue;
                this.flushStoreToWriter(force);
            }
        }
        if (force && this.store.length() > 0) {
            this.flushStoreToWriter(force);
        }
    }

    private void flushStoreToWriter(boolean force) throws IOException {
        int len = this.store.length();
        for (int i = 0; i < len; ++i) {
            int cp;
            if (this.curoff + 2 > this.results.length) {
                this.writer.write(this.results, 0, this.curoff);
                this.curoff = 0;
            }
            if ((cp = this.store.intAt(i)) < 65536) {
                this.results[this.curoff++] = (char)cp;
                continue;
            }
            this.results[this.curoff++] = (char)(55296 + ((cp -= 65536) >> 10));
            this.results[this.curoff++] = (char)(56320 + (cp & 0x3FF));
        }
        this.store.setLength(0);
        if (force) {
            this.writer.write(this.results, 0, this.curoff);
            this.curoff = 0;
        }
    }

    public Normalizer append(char[] chars, int off, int len) throws IOException {
        int i;
        boolean needNorm;
        int end = off + len;
        boolean bl = needNorm = this.lastChar != '\uffff';
        if (!needNorm) {
            for (i = off; i < end; ++i) {
                if (chars[i] < this.minCP) continue;
                needNorm = true;
                break;
            }
            if (!needNorm) {
                this.flush(true);
                this.writer.write(chars, off, len);
                return this;
            }
        }
        for (i = off; i < end; ++i) {
            int cp;
            int c = chars[i];
            if (this.lastChar == '\uffff') {
                if (Character.isHighSurrogate((char)c)) {
                    this.lastChar = (char)c;
                    continue;
                }
                cp = c;
            } else {
                cp = Character.toCodePoint(this.lastChar, (char)c);
                this.lastChar = (char)65535;
            }
            this.appendCodePoint(cp);
        }
        return this;
    }

    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        int i;
        boolean needNorm;
        boolean bl = needNorm = this.lastChar != '\uffff';
        if (!needNorm) {
            for (i = start; i < end; ++i) {
                if (csq.charAt(i) < this.minCP) continue;
                needNorm = true;
                break;
            }
            if (!needNorm) {
                this.flush(true);
                this.writer.append(csq, start, end);
                return this;
            }
        }
        for (i = start; i < end; ++i) {
            int cp;
            int c = csq.charAt(i);
            if (this.lastChar == '\uffff') {
                if (Character.isHighSurrogate((char)c)) {
                    this.lastChar = (char)c;
                    continue;
                }
                cp = c;
            } else {
                cp = Character.toCodePoint(this.lastChar, (char)c);
                this.lastChar = (char)65535;
            }
            this.appendCodePoint(cp);
        }
        return this;
    }

    public Appendable append(char c) throws IOException {
        int cp;
        if (this.lastChar == '\uffff') {
            if (Character.isHighSurrogate((char)c)) {
                this.lastChar = (char)c;
                return this;
            }
            cp = c;
        } else {
            cp = Character.toCodePoint(this.lastChar, (char)c);
            this.lastChar = (char)65535;
        }
        this.appendCodePoint(cp);
        return this;
    }

    public UnicodeNormalizer appendCodePoint(int cp) throws IOException {
        if (cp < 0 || cp > 0x10FFFF) {
            throw new IllegalArgumentException();
        }
        CodePoint codepoint = normData.get(cp);
        if (codepoint == null || codepoint.canonicalCombiningClass == 0) {
            this.flush(false);
        }
        normData.appendDecomposition(cp, codepoint, this.buffer, this.canonical);
        return this;
    }

    public void reset() {
        this.store.setLength(0);
        this.buffer.reset();
        this.lastChar = (char)65535;
        this.lastCC = (short)256;
        this.curoff = 0;
    }

    static {
        try {
            File normMapFile = new File(System.getProperty(KEY_NORM_DATA_FILE, NORM_DATA_FILE));
            InputStream in = null;
            in = normMapFile.exists() && normMapFile.isFile() ? new FileInputStream(normMapFile) : UnicodeNormalizer.class.getResourceAsStream(NORM_DATA_FILE);
            if (in != null) {
                normData.load(in);
                in.close();
            } else {
                Loggers.logger.log(new NormalizerConfigurationException(NORM_DATA_FILE));
            }
        }
        catch (IOException e) {
            Loggers.logger.log(new NormalizerConfigurationException(NORM_DATA_FILE, (Throwable)e));
        }
    }
}

