/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer.unicode;

import com.ibm.es.nuvo.normalizer.unicode.CodePoint;
import com.ibm.es.nuvo.normalizer.unicode.CodePointMap;
import com.ibm.es.nuvo.normalizer.unicode.CodePointSink;
import com.ibm.es.nuvo.normalizer.unicode.CompositionMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

class NormalizationData {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private CodePointMap codepoints;
    private CompositionMap compositions;
    private long version;
    int minCP4NFC = 65535;
    int minCP4NFKC = 65535;
    int minCP4NFD = 65535;
    int minCP4NFKD = 65535;

    NormalizationData(long version) {
        this.version = version;
        this.codepoints = new CodePointMap();
        this.compositions = new CompositionMap();
    }

    long getVersion() {
        return this.version;
    }

    CodePoint get(int codepoint) {
        return this.codepoints.get(codepoint);
    }

    CodePoint safeGet(int codepoint) {
        CodePoint cp = this.get(codepoint);
        if (cp != null) {
            return cp;
        }
        cp = new CodePoint(codepoint);
        this.codepoints.put(codepoint, cp);
        return cp;
    }

    short getCCC(int codepoint) {
        CodePoint cp = this.codepoints.get(codepoint);
        return cp != null ? cp.canonicalCombiningClass : (short)0;
    }

    int getComposition(int first, int second) {
        int t;
        int v;
        if (first < 0 || first > 0x10FFFF || second < 0 || second > 0x10FFFF) {
            return -1;
        }
        int composition = this.compositions.get(first, second);
        if (composition != -1) {
            return composition;
        }
        int l = first - 4352;
        if (0 <= l && l < 19 && 0 <= (v = second - 4449) && v < 21) {
            return 44032 + (l * 21 + v) * 28;
        }
        int s = first - 44032;
        if (0 <= s && s < 11172 && s % 28 == 0 && 0 <= (t = second - 4519) && t < 28) {
            return first + t;
        }
        return -1;
    }

    void appendDecomposition(int codepoint, CodePoint cp, CodePointSink buffer, boolean canonical) {
        int s;
        short cc = 0;
        if (cp != null) {
            int[] map;
            cc = cp.canonicalCombiningClass;
            if (!(canonical && cp.compatibility || (map = cp.decomposition) == null || map.length <= 0)) {
                for (int i = 0; i < map.length; ++i) {
                    int c = map[i];
                    this.appendDecomposition(c, this.get(c), buffer, canonical);
                }
                return;
            }
        }
        if ((s = codepoint - 44032) >= 0 && s < 11172) {
            int l = 4352 + s / 588;
            int v = 4449 + s % 588 / 28;
            int t = 4519 + s % 28;
            buffer.add(l, (short)0);
            buffer.add(v, (short)0);
            if (t != 4519) {
                buffer.add(t, (short)0);
            }
            return;
        }
        buffer.add(codepoint, cc);
    }

    void putComposition(int first, int second, int codepoint) {
        this.compositions.put(first, second, codepoint);
    }

    CodePoint setUCD(int codepoint, short cc, int[] decomposition, boolean compatibility) {
        CodePoint cp = this.safeGet(codepoint);
        cp.canonicalCombiningClass = cc;
        cp.decomposition = decomposition;
        cp.compatibility = compatibility;
        return cp;
    }

    void setQuickCheckFlags(int startCP, int endCP, byte flags) {
        for (int cp = startCP; cp <= endCP; ++cp) {
            this.safeGet((int)cp).quickCheckFlags = (byte)(this.safeGet((int)cp).quickCheckFlags | flags);
            if ((flags & 0x11) != 0 && cp < this.minCP4NFC) {
                this.minCP4NFC = cp;
            }
            if ((flags & 0x22) != 0 && cp < this.minCP4NFKC) {
                this.minCP4NFKC = cp;
            }
            if ((flags & 4) != 0 && cp < this.minCP4NFD) {
                this.minCP4NFD = cp;
            }
            if ((flags & 8) == 0 || cp >= this.minCP4NFKD) continue;
            this.minCP4NFKD = cp;
        }
    }

    void setCompositionExclusion(int startCP, int endCP, boolean excluded) {
        for (int cp = startCP; cp <= endCP; ++cp) {
            this.safeGet((int)cp).excluded = excluded;
        }
    }

    void setExpandsOnFlags(int startCP, int endCP, byte flags) {
        for (int cp = startCP; cp <= endCP; ++cp) {
            this.safeGet((int)cp).expandsOnFlags = (byte)(this.safeGet((int)cp).expandsOnFlags | flags);
        }
    }

    void save(OutputStream out) throws IOException {
        DeflaterOutputStream gout = new DeflaterOutputStream(out, new Deflater(-1));
        DataOutputStream dout = new DataOutputStream(gout);
        dout.writeLong(this.version);
        dout.writeInt(this.minCP4NFC);
        dout.writeInt(this.minCP4NFKC);
        dout.writeInt(this.minCP4NFD);
        dout.writeInt(this.minCP4NFKD);
        int size = this.codepoints.size();
        dout.writeInt(size);
        CodePointMap.CodePointIterator cps = this.codepoints.values();
        while (cps.hasNext()) {
            CodePoint cp = cps.next();
            dout.writeInt(cp.code);
            dout.writeShort(cp.canonicalCombiningClass);
            if (cp.decomposition == null || cp.decomposition.length == 0) {
                dout.writeInt(0);
            } else {
                dout.writeInt(cp.decomposition.length);
                for (int j = 0; j < cp.decomposition.length; ++j) {
                    dout.writeInt(cp.decomposition[j]);
                }
            }
            byte b = (byte)(cp.compatibility ? 1 : 0);
            b = (byte)(b | (cp.excluded ? 2 : 0));
            dout.writeByte(b);
        }
        size = this.compositions.size();
        dout.writeInt(size);
        CompositionMap.MapIterator comps = this.compositions.maps();
        while (comps.next()) {
            long pair = (long)comps.getFirst() << 32 | (long)comps.getSecond();
            int comp = comps.getComposition();
            dout.writeLong(pair);
            dout.writeInt(comp);
        }
        dout.flush();
        gout.finish();
    }

    void load(InputStream in) throws IOException {
        int i;
        DataInputStream din = new DataInputStream(new InflaterInputStream(in));
        this.version = din.readLong();
        this.minCP4NFC = din.readInt();
        this.minCP4NFKC = din.readInt();
        this.minCP4NFD = din.readInt();
        this.minCP4NFKD = din.readInt();
        int size = din.readInt();
        this.codepoints = new CodePointMap();
        for (i = 0; i < size; ++i) {
            CodePoint cp = new CodePoint(din.readInt());
            cp.canonicalCombiningClass = din.readShort();
            int l = din.readInt();
            if (l == 0) {
                cp.decomposition = null;
            } else {
                cp.decomposition = new int[l];
                for (int j = 0; j < cp.decomposition.length; ++j) {
                    cp.decomposition[j] = din.readInt();
                }
            }
            byte b = din.readByte();
            cp.compatibility = (b & 1) != 0;
            cp.excluded = (b & 2) != 0;
            this.codepoints.put(cp.code, cp);
        }
        size = din.readInt();
        this.compositions = new CompositionMap();
        for (i = 0; i < size; ++i) {
            long pair = din.readLong();
            Integer comp = din.readInt();
            int first = (int)(pair >>> 32);
            int second = (int)pair;
            this.compositions.put(first, second, comp);
        }
    }

    private static final class Hangul {
        private static final int S_BASE = 44032;
        private static final int J_L_BASE = 4352;
        private static final int J_V_BASE = 4449;
        private static final int J_T_BASE = 4519;
        private static final int J_L_COUNT = 19;
        private static final int J_V_COUNT = 21;
        private static final int J_T_COUNT = 28;
        private static final int J_N_COUNT = 588;
        private static final int S_COUNT = 11172;

        private Hangul() {
        }
    }
}

