/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer.unicode;

class IntBuffer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int[] value;
    private int count = 0;

    IntBuffer() {
        this(16);
    }

    IntBuffer(int capacity) {
        this.value = new int[capacity];
    }

    public IntBuffer append(int i) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count] = i;
        ++this.count;
        return this;
    }

    public IntBuffer append(int[] data) {
        int newSize = this.count + data.length;
        this.ensureCapacity(newSize);
        System.arraycopy(data, 0, this.value, this.count, data.length);
        this.count = newSize;
        return this;
    }

    private void ensureCapacity(int min) {
        if (min > this.value.length) {
            int twice = (this.value.length << 1) + 2;
            int[] temp = new int[min > twice ? min : twice];
            System.arraycopy(this.value, 0, temp, 0, this.count);
            this.value = temp;
        }
    }

    public int intAt(int index) {
        return this.value[index];
    }

    public void setIntAt(int index, int v) {
        this.value[index] = v;
    }

    public int length() {
        return this.count;
    }

    public void setLength(int length) {
        this.ensureCapacity(length);
        this.count = length;
    }

    public int[] toIntArray() {
        int[] buffer = new int[this.count];
        System.arraycopy(this.value, 0, buffer, 0, this.count);
        return buffer;
    }
}

