/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer.unicode;

public class CompositionMap {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int NO_COMP = -1;
    private IntMap<IntMap<Integer>> maps = new IntMap();

    public String toString() {
        return this.maps.toString();
    }

    public void put(int first, int second, int codepoint) {
        Integer cp;
        IntMap map = (IntMap)((IntMap)this.maps).get(second);
        if (map == null) {
            map = new IntMap();
            ((IntMap)this.maps).put(second, map);
        }
        if ((cp = (Integer)map.get(first)) == null) {
            cp = codepoint;
            map.put(first, cp);
        }
    }

    public int get(int first, int second) {
        IntMap map = (IntMap)((IntMap)this.maps).get(second);
        if (map == null) {
            return -1;
        }
        Integer cp = (Integer)map.get(first);
        if (cp == null) {
            return -1;
        }
        return cp;
    }

    public int size() {
        int count = 0;
        for (int i = 0; i < ((IntMap)this.maps).count; ++i) {
            IntMap map = (IntMap)((IntMap)this.maps).entries[i].value;
            count += map.size();
        }
        return count;
    }

    public MapIterator maps() {
        return new MapIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntMap<V> {
        private int count = 0;
        private MapEntry<V>[] entries = new MapEntry[16];
        private int minKey = Integer.MAX_VALUE;
        private int maxKey = Integer.MIN_VALUE;

        private IntMap() {
        }

        private V put(int key, V value) {
            int i = -1;
            MapEntry<V> entry = null;
            while (++i < this.count && ((MapEntry)(entry = this.entries[i])).key < key) {
            }
            if (i < this.count && ((MapEntry)entry).key == key) {
                ((MapEntry)entry).value = value;
                return (V)((MapEntry)entry).value;
            }
            int min = this.count + 1;
            if (min > this.entries.length) {
                int twice = (this.entries.length << 1) + 2;
                MapEntry[] temp = new MapEntry[min > twice ? min : twice];
                System.arraycopy(this.entries, 0, temp, 0, this.count);
                this.entries = temp;
            }
            entry = new MapEntry(key, value);
            for (int j = this.count; j > i; --j) {
                this.entries[j] = this.entries[j - 1];
            }
            this.entries[i] = entry;
            ++this.count;
            if (key < this.minKey) {
                this.minKey = key;
            }
            if (key > this.maxKey) {
                this.maxKey = key;
            }
            return (V)((MapEntry)entry).value;
        }

        private V get(int key) {
            if (key > this.maxKey || key < this.minKey) {
                return null;
            }
            int i = -1;
            MapEntry<V> entry = null;
            while (++i < this.count && ((MapEntry)(entry = this.entries[i])).key < key) {
            }
            if (i < this.count && ((MapEntry)entry).key == key) {
                return (V)((MapEntry)entry).value;
            }
            return null;
        }

        private int size() {
            return this.count;
        }

        private MapEntryIterator<V> maps() {
            return new MapEntryIterator(this.entries, this.count);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            builder.append('\n');
            for (int i = 0; i < this.count; ++i) {
                int key = ((MapEntry)this.entries[i]).key;
                Object value = ((MapEntry)this.entries[i]).value;
                builder.append(Integer.toHexString(key));
                builder.append('[');
                if (value instanceof Integer) {
                    builder.append(Integer.toHexString((Integer)value));
                } else {
                    builder.append(value);
                }
                builder.append(']');
                builder.append('\n');
            }
            builder.append(')');
            builder.append('\n');
            return builder.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class MapEntryIterator<V> {
            private int index = -1;
            private int count;
            private MapEntry<V>[] entries;

            private MapEntryIterator(MapEntry<V>[] entries, int count) {
                this.count = count;
                this.entries = entries;
            }

            public boolean next() {
                return ++this.index < this.count;
            }

            public int key() {
                return ((MapEntry)this.entries[this.index]).key;
            }

            public V value() {
                return (V)((MapEntry)this.entries[this.index]).value;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class MapEntry<V> {
            private final int key;
            private V value;

            private MapEntry(int key, V value) {
                this.key = key;
                this.value = value;
            }
        }
    }

    public class MapIterator {
        private IntMap.MapEntryIterator<IntMap<Integer>> secondEntries;
        private IntMap.MapEntryIterator<Integer> firstEntries;

        private MapIterator() {
            this.secondEntries = ((IntMap)CompositionMap.this.maps).maps();
            this.firstEntries = this.secondEntries.next() ? ((IntMap)this.secondEntries.value()).maps() : null;
        }

        public boolean next() {
            boolean hasNext = false;
            while (this.firstEntries != null && !(hasNext = this.firstEntries.next())) {
                if (this.secondEntries.next()) {
                    this.firstEntries = ((IntMap)this.secondEntries.value()).maps();
                    continue;
                }
                return false;
            }
            return hasNext;
        }

        public int getFirst() {
            return this.firstEntries.key();
        }

        public int getSecond() {
            return this.secondEntries.key();
        }

        public int getComposition() {
            return this.firstEntries.value();
        }
    }
}

