/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer.unicode;

import com.ibm.es.nuvo.normalizer.unicode.CodePoint;

final class CodePointSink {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int[] codepointList;
    private short[] ccList;
    private short nextCC;
    private int wPos = 0;
    private int rPos = 0;

    CodePointSink() {
        this(256);
    }

    CodePointSink(int capacity) {
        this.codepointList = new int[capacity];
        this.ccList = new short[capacity];
        this.nextCC = 0;
    }

    void reset() {
        this.rPos = 0;
        this.wPos = 0;
    }

    int remain() {
        return this.wPos - this.rPos;
    }

    int poll() {
        if (this.wPos > this.rPos) {
            int cp = this.codepointList[this.rPos];
            ++this.rPos;
            this.nextCC = this.wPos > this.rPos ? this.ccList[this.rPos] : (short)0;
            return cp;
        }
        return -1;
    }

    short nextCC() {
        return this.nextCC;
    }

    void add(CodePoint cp) {
        this.add(cp.code, cp.canonicalCombiningClass);
    }

    void add(int codepoint, short cc) {
        if (this.wPos + 1 >= this.codepointList.length) {
            if (this.rPos > 0) {
                int len = this.wPos - this.rPos;
                for (int i = 0; i < len; ++i) {
                    this.codepointList[i] = this.codepointList[this.rPos + i];
                    this.ccList[i] = this.ccList[this.rPos + i];
                }
                this.wPos = len;
                this.rPos = 0;
            } else {
                int capacity = this.codepointList.length * 2;
                int[] temp = new int[capacity];
                System.arraycopy(this.codepointList, this.rPos, temp, 0, this.wPos - this.rPos);
                this.codepointList = temp;
                short[] temp2 = new short[capacity];
                System.arraycopy(this.ccList, this.rPos, temp2, 0, this.wPos - this.rPos);
                this.ccList = temp2;
                this.wPos -= this.rPos;
                this.rPos = 0;
            }
        }
        this.codepointList[this.wPos] = codepoint;
        this.ccList[this.wPos] = cc;
        if (cc != 0 && this.wPos > this.rPos) {
            for (int j = this.wPos; j > this.rPos; --j) {
                int c1 = this.codepointList[j - 1];
                int c2 = this.codepointList[j];
                short cc1 = this.ccList[j - 1];
                short cc2 = this.ccList[j];
                if (cc1 == 0) break;
                if (cc1 <= cc2) continue;
                this.codepointList[j - 1] = c2;
                this.codepointList[j] = c1;
                this.ccList[j - 1] = cc2;
                this.ccList[j] = cc1;
            }
        }
        if (this.rPos == this.wPos) {
            this.nextCC = this.ccList[this.wPos];
        }
        ++this.wPos;
    }
}

