/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer.unicode;

import com.ibm.es.nuvo.normalizer.unicode.CodePoint;

public class CodePointMap {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int PLAIN_MASK_SHIFT = 16;
    private static final int PLAIN_INDEX_SHIFT = 16;
    private static final int PLANE_INDEX_LENGTH = 32;
    private static final int PLANE_MASK = -65536;
    private static final int BMP_MASK_SHIFT = 5;
    private static final int BMP_INDEX_SHIFT = 11;
    private static final int BMP_MASK = 2047;
    private static final int BASE_MASK_SHIFT = 8;
    private static final int BASE_INDEX_SHIFT = 8;
    private static final int BASE_MASK = 255;
    private static final int BMP_INDEX_LENGTH = 32;
    private static final int BASE_INDEX_LENGTH = 8;
    private static final int LEAF_ENTRY_LENGTH = 256;
    private final PlaneEntry[] planes = new PlaneEntry[32];

    public CodePoint get(int codepoint) {
        int plane = codepoint >>> 16;
        char bmp = (char)(codepoint << 16 >>> 16);
        if (plane >= 32) {
            return null;
        }
        PlaneEntry entry = this.planes[plane];
        return entry == null ? null : entry.get(bmp);
    }

    public CodePoint safeGet(int codepoint) {
        CodePoint cp;
        int plane = codepoint >>> 16;
        char bmp = (char)(codepoint << 16 >>> 16);
        if (plane > 32) {
            throw new IllegalArgumentException();
        }
        PlaneEntry entry = this.planes[plane];
        if (entry == null) {
            this.planes[plane] = entry = new PlaneEntry();
        }
        if ((cp = entry.get(bmp)) != null) {
            return cp;
        }
        cp = new CodePoint(codepoint);
        entry.put(bmp, cp);
        return cp;
    }

    public void put(int codepoint, CodePoint cp) {
        int plane = codepoint >>> 16;
        char bmp = (char)(codepoint << 16 >>> 16);
        if (plane > 32) {
            throw new IllegalArgumentException();
        }
        PlaneEntry entry = this.planes[plane];
        if (entry == null) {
            this.planes[plane] = entry = new PlaneEntry();
        }
        entry.put(bmp, cp);
    }

    public CodePointIterator values() {
        return new CodePointIterator();
    }

    public int size() {
        int count = 0;
        CodePointIterator cps = this.values();
        while (cps.hasNext()) {
            ++count;
        }
        return count;
    }

    private static final class IndexEntry {
        private CodePoint[] codepoints = new CodePoint[256];

        private IndexEntry() {
        }

        private CodePoint get(char ch) {
            return this.codepoints[ch];
        }

        private void put(char ch, CodePoint cp) {
            this.codepoints[ch] = cp;
        }
    }

    private static final class BmpEntry {
        private int minKey = 8;
        private int maxKey = 0;
        private IndexEntry[] indexes = new IndexEntry[8];

        private BmpEntry() {
        }

        private CodePoint get(char ch) {
            int index = ch >>> 8;
            if (index < this.minKey || index > this.maxKey) {
                return null;
            }
            IndexEntry entry = this.indexes[index];
            return entry == null ? null : entry.get((char)(ch & 0xFF));
        }

        private void put(char ch, CodePoint cp) {
            int index = ch >>> 8;
            IndexEntry entry = this.indexes[index];
            if (entry == null) {
                this.indexes[index] = entry = new IndexEntry();
                if (index < this.minKey) {
                    this.minKey = index;
                }
                if (index > this.maxKey) {
                    this.maxKey = index;
                }
            }
            entry.put((char)(ch & 0xFF), cp);
        }
    }

    private static final class PlaneEntry {
        private int minKey = 32;
        private int maxKey = 0;
        private BmpEntry[] bmps = new BmpEntry[32];

        private PlaneEntry() {
        }

        private CodePoint get(char ch) {
            int index = ch >>> 11;
            if (index < this.minKey || index > this.maxKey) {
                return null;
            }
            BmpEntry entry = this.bmps[index];
            return entry == null ? null : entry.get((char)(ch & 0x7FF));
        }

        private void put(char bmp, CodePoint cp) {
            int index = bmp >>> 11;
            BmpEntry entry = this.bmps[index];
            if (entry == null) {
                this.bmps[index] = entry = new BmpEntry();
                if (index < this.minKey) {
                    this.minKey = index;
                }
                if (index > this.maxKey) {
                    this.maxKey = index;
                }
            }
            entry.put((char)(bmp & 0x7FF), cp);
        }
    }

    public class CodePointIterator {
        private PlaneEntry planeEntry = null;
        private int planeIndex = -1;
        private BmpEntry bmpEntry = null;
        private int bmpIndex = -1;
        private IndexEntry baseEntry = null;
        private int baseIndex = -1;
        private CodePoint codepoint = null;
        private int index = -1;

        private CodePointIterator() {
            this.moveToNextPlane();
        }

        public boolean hasNext() {
            boolean found;
            while ((found = this.moveToNextLeafInBaseIndex()) || this.moveToNextBaseEntryInBmp() || this.moveToNextBmpInPlane() || this.moveToNextPlane()) {
                if (!found) continue;
                return true;
            }
            return false;
        }

        public CodePoint next() {
            return this.codepoint;
        }

        private boolean searchFirstBaseEntryInPlane() {
            this.bmpIndex = 0;
            while (this.bmpIndex < this.planeEntry.bmps.length) {
                this.bmpEntry = this.planeEntry.bmps[this.bmpIndex];
                if (this.bmpEntry != null && this.searchFirstBaseEntryInBmp()) {
                    return true;
                }
                ++this.bmpIndex;
            }
            return false;
        }

        private boolean searchFirstBaseEntryInBmp() {
            this.baseIndex = 0;
            while (this.baseIndex < this.bmpEntry.indexes.length) {
                this.baseEntry = this.bmpEntry.indexes[this.baseIndex];
                if (this.baseEntry != null) {
                    return true;
                }
                ++this.baseIndex;
            }
            return false;
        }

        private boolean moveToNextLeafInBaseIndex() {
            if (this.baseEntry == null) {
                return false;
            }
            while (++this.index < this.baseEntry.codepoints.length) {
                if (this.baseEntry.codepoints[this.index] == null) continue;
                this.codepoint = this.baseEntry.codepoints[this.index];
                return true;
            }
            this.index = -1;
            return false;
        }

        private boolean moveToNextBaseEntryInBmp() {
            if (this.bmpEntry == null) {
                return false;
            }
            while (++this.baseIndex < this.bmpEntry.indexes.length) {
                if (this.bmpEntry.indexes[this.baseIndex] == null) continue;
                this.baseEntry = this.bmpEntry.indexes[this.baseIndex];
                return true;
            }
            this.baseIndex = -1;
            return false;
        }

        private boolean moveToNextBmpInPlane() {
            if (this.planeEntry == null) {
                return false;
            }
            while (++this.bmpIndex < this.planeEntry.bmps.length) {
                if (this.planeEntry.bmps[this.bmpIndex] == null) continue;
                this.bmpEntry = this.planeEntry.bmps[this.bmpIndex];
                return this.searchFirstBaseEntryInBmp();
            }
            this.bmpIndex = -1;
            return false;
        }

        private boolean moveToNextPlane() {
            this.planeEntry = null;
            while (++this.planeIndex < CodePointMap.this.planes.length) {
                if (CodePointMap.this.planes[this.planeIndex] == null) continue;
                this.planeEntry = CodePointMap.this.planes[this.planeIndex];
                return this.searchFirstBaseEntryInPlane();
            }
            this.planeIndex = -1;
            return false;
        }
    }
}

