/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer.unicode;

final class CodePoint {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    int code;
    short canonicalCombiningClass;
    byte quickCheckFlags;
    byte expandsOnFlags;
    byte combiningFlags;
    int[] decomposition;
    boolean compatibility;
    boolean excluded;

    CodePoint(int cp) {
        this.code = cp;
        this.canonicalCombiningClass = 0;
        this.quickCheckFlags = 0;
        this.expandsOnFlags = 0;
        this.combiningFlags = 0;
        this.decomposition = null;
        this.compatibility = false;
        this.excluded = false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.canonicalCombiningClass).append(';');
        builder.append(Integer.toHexString(this.quickCheckFlags)).append(';');
        builder.append(Integer.toHexString(this.expandsOnFlags)).append(';');
        builder.append(Integer.toHexString(this.combiningFlags)).append(';');
        if (this.decomposition != null) {
            for (int i = 0; i < this.decomposition.length; ++i) {
                builder.append(CodePoint.hex(this.decomposition[i]));
                builder.append(' ');
            }
        }
        builder.append(';');
        builder.append(this.compatibility).append(';');
        builder.append(this.excluded).append(';');
        return builder.toString();
    }

    static final String hex(int codepoint) {
        StringBuilder builder = new StringBuilder();
        String v = Integer.toHexString(codepoint);
        if (codepoint < 65536) {
            builder.append("0000".substring(v.length(), 4)).append(v);
        } else {
            builder.append("000000".substring(v.length(), 6)).append(v);
        }
        return builder.toString();
    }
}

