/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer.map;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

final class NormalizationMap {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    int minCodePoint = 65535;
    MapRuleSet ruleSet = new MapRuleSet();

    NormalizationMap() {
    }

    char[] match(char c) {
        MapRule rule = this.ruleSet.match(c);
        return rule != null ? rule.output : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(InputStream in) throws IOException {
        NormalizationMapReader reader = new NormalizationMapReader(new InputStreamReader(in, "UTF-8"), 1024);
        try {
            String line = null;
            StringBuilder builder = new StringBuilder();
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                String v;
                int index = line.indexOf(61);
                builder.setLength(0);
                int start = index;
                start = index + 1;
                int end = line.indexOf(32, start);
                while (end != -1) {
                    v = line.substring(start, end).trim();
                    if (v.length() > 0) {
                        builder.append((char)Integer.parseInt(v, 16));
                    }
                    start = end + 1;
                    end = line.indexOf(32, start);
                }
                v = line.substring(start).trim();
                if (v.length() > 0) {
                    builder.append((char)Integer.parseInt(v, 16));
                }
                char left = (char)Integer.parseInt(line.substring(0, index).trim(), 16);
                char[] right = new char[builder.length()];
                for (int i = 0; i < right.length; ++i) {
                    right[i] = builder.charAt(i);
                }
                if (left < this.minCodePoint) {
                    this.minCodePoint = left;
                }
                this.ruleSet.add(left, right);
            }
        }
        finally {
            this.ruleSet.compile();
            reader.close();
        }
    }

    private static final class MapRule {
        private final char key;
        final char[] output;

        MapRule(char key, char[] output) {
            this.key = key;
            this.output = output;
        }

        final int getIndex() {
            return this.key & 0xFF;
        }

        final boolean match(char c) {
            return this.key == c;
        }
    }

    private static final class IndexEntry {
        private char minKey;
        private char maxKey;
        private MapRule[] rules;

        private IndexEntry() {
        }

        static /* synthetic */ MapRule[] access$202(IndexEntry x0, MapRule[] x1) {
            x0.rules = x1;
            return x1;
        }
    }

    static final class MapRuleSet {
        private List<MapRule> ruleList = new ArrayList<MapRule>();
        private IndexEntry[] index = null;

        public void add(char key, char[] output) {
            this.ruleList.add(new MapRule(key, output));
            this.index = null;
        }

        public MapRule match(char key) {
            IndexEntry e = this.index[key & 0xFF];
            if (e.maxKey < key || e.minKey > key) {
                return null;
            }
            for (int i = 0; i < e.rules.length; ++i) {
                if (e.rules[i].key != key) continue;
                return e.rules[i];
            }
            return null;
        }

        public void compile() {
            int i;
            int size = this.ruleList.size();
            this.index = new IndexEntry[256];
            int[] tempIndex = new int[this.index.length + 1];
            ArrayList<MapRule> temp = new ArrayList<MapRule>(size);
            int[] values = new int[size];
            for (i = 0; i < size; ++i) {
                MapRule rule = this.ruleList.get(i);
                values[i] = rule.getIndex();
            }
            for (i = 0; i < tempIndex.length - 1; ++i) {
                tempIndex[i] = temp.size();
                for (int j = 0; j < size; ++j) {
                    if (values[j] >= 0) {
                        if (values[j] != i) continue;
                        temp.add(this.ruleList.get(j));
                        continue;
                    }
                    MapRule rule = this.ruleList.get(j);
                    if (rule.getIndex() != i) continue;
                    temp.add(rule);
                }
            }
            tempIndex[tempIndex.length - 1] = temp.size();
            for (i = 0; i < this.index.length; ++i) {
                IndexEntry entry = new IndexEntry();
                int start = tempIndex[i];
                int end = tempIndex[i + 1];
                int len = end - start;
                IndexEntry.access$202(entry, new MapRule[len]);
                entry.maxKey = '\u0000';
                entry.minKey = '\uffff';
                for (int j = 0; j < len; ++j) {
                    MapRule rule = (MapRule)temp.get(start + j);
                    if (rule.key < entry.minKey) {
                        entry.minKey = rule.key;
                    }
                    if (rule.key > entry.maxKey) {
                        entry.maxKey = rule.key;
                    }
                    ((IndexEntry)entry).rules[j] = rule;
                }
                this.index[i] = entry;
            }
        }
    }

    private static class NormalizationMapReader
    extends BufferedReader {
        public NormalizationMapReader(Reader in, int sz) {
            super(in, sz);
        }

        public String readLine() throws IOException {
            String line;
            while ((line = super.readLine()) != null) {
                int comment = line.indexOf("//");
                if (comment != -1) {
                    line = line.substring(0, comment);
                }
                if (line.length() == 0) continue;
            }
            return line;
        }
    }
}

