/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer.map;

import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.normalizer.Normalizer;
import com.ibm.es.nuvo.normalizer.NormalizerConfigurationException;
import com.ibm.es.nuvo.normalizer.map.NormType;
import com.ibm.es.nuvo.normalizer.map.NormalizationMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public class MapNormalizer
extends Normalizer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int DEFAULT_BUFFER_SIZE = 16;
    private static NormalizationMap normMapType1 = new NormalizationMap();
    private static NormalizationMap normMapType2 = new NormalizationMap();
    private static final String NORM_MAP_FILE_TYPE1 = "type1_rules.dat";
    private static final String NORM_MAP_FILE_TYPE2 = "type2_rules.dat";
    private static final String KEY_NORM_MAP_FILE_TYPE1 = "whitney.normalizer.type1";
    private static final String KEY_NORM_MAP_FILE_TYPE2 = "whitney.normalizer.type2";
    private final NormalizationMap normMap;
    private final char[] buffer;

    private static void load(NormalizationMap normMap, String normMapPath, String key) {
        try {
            File normMapFile = new File(System.getProperty(key, normMapPath));
            InputStream in = null;
            in = normMapFile.exists() && normMapFile.isFile() ? new FileInputStream(normMapFile) : MapNormalizer.class.getResourceAsStream(normMapPath);
            if (in != null) {
                normMap.load(in);
                in.close();
            } else {
                Loggers.logger.log(new NormalizerConfigurationException(normMapPath));
            }
        }
        catch (IOException e) {
            Loggers.logger.log(new NormalizerConfigurationException(normMapPath, (Throwable)e));
        }
    }

    MapNormalizer(NormType type) {
        this(type, null);
    }

    MapNormalizer(NormType type, Writer writer) {
        this(type, writer, 16);
    }

    MapNormalizer(NormType type, Writer writer, int bufSize) {
        super(writer);
        switch (type) {
            case TYPE1: {
                this.normMap = normMapType1;
                break;
            }
            case TYPE2: {
                this.normMap = normMapType2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.buffer = new char[bufSize];
    }

    public Normalizer append(char[] chars, int off, int len) throws IOException {
        int end = off + len;
        int curOff = 0;
        for (int j = off; j < end; ++j) {
            char c;
            if (curOff + 1 > this.buffer.length) {
                this.writer.write(this.buffer, 0, curOff);
                curOff = 0;
            }
            if ((c = chars[j]) < this.normMap.minCodePoint) {
                this.buffer[curOff++] = c;
                continue;
            }
            char[] map = this.normMap.match(c);
            if (map == null) {
                this.buffer[curOff++] = c;
                continue;
            }
            if (curOff + map.length > this.buffer.length) {
                this.writer.write(this.buffer, 0, curOff);
                curOff = 0;
            }
            for (int i = 0; i < map.length; ++i) {
                this.buffer[curOff++] = map[i];
            }
        }
        if (curOff > 0) {
            this.writer.write(this.buffer, 0, curOff);
            curOff = 0;
        }
        return this;
    }

    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        int curOff = 0;
        for (int j = start; j < end; ++j) {
            char c;
            if (curOff + 1 > this.buffer.length) {
                this.writer.write(this.buffer, 0, curOff);
                curOff = 0;
            }
            if ((c = csq.charAt(j)) < this.normMap.minCodePoint) {
                this.buffer[curOff++] = c;
                continue;
            }
            char[] map = this.normMap.match(c);
            if (map == null) {
                this.buffer[curOff++] = c;
                continue;
            }
            if (curOff + map.length > this.buffer.length) {
                this.writer.write(this.buffer, 0, curOff);
                curOff = 0;
            }
            for (int i = 0; i < map.length; ++i) {
                this.buffer[curOff++] = map[i];
            }
        }
        if (curOff > 0) {
            this.writer.write(this.buffer, 0, curOff);
            curOff = 0;
        }
        return this;
    }

    public Appendable append(char c) throws IOException {
        if (c < this.normMap.minCodePoint) {
            this.writer.append(c);
        } else {
            char[] map = this.normMap.match(c);
            if (map == null) {
                this.writer.append(c);
            } else {
                for (int i = 0; i < map.length; ++i) {
                    this.writer.append(map[i]);
                }
            }
        }
        return this;
    }

    static {
        MapNormalizer.load(normMapType1, NORM_MAP_FILE_TYPE1, KEY_NORM_MAP_FILE_TYPE1);
        MapNormalizer.load(normMapType2, NORM_MAP_FILE_TYPE2, KEY_NORM_MAP_FILE_TYPE2);
    }
}

